{****************************************************************************

                        FPKPascal Runtime-Library
                         Copyright (c) 1993,96 by 
                     Florian Klmpfl & Michael Spiegel

 ****************************************************************************}
 
{
  History:
  29.5.1994: Version 1.0 
             Unit ist komplett implementiert 
  14.6.1994: Version 1.01
             Adresse aus welcher startattrib ausgelesen wurde war falsch;
             behoben
  18.8.1994: Version 1.1
             Ursprung fr windmax und windmin ist nun (0,0)
  19.9.1994: Version 1.11
             keypressed gab false zurck, wenn noch ein erweiterter
             Tastencode vorlag; behoben
  27.2.1995: Version 1.12
             Zeilenumbruch wurde von crtinoutfunc nicht korrekt durchgefhrt;
             behoben
  20.1.1996: Version 1.13
             unbenutzte Variablen entfernt 
}

unit crt;
 
{$E-}

  interface

    const
       { Bildschirmmodi }
       bw40 = 0;
       co40 = 1;
       bw80 = 2;
       co80 = 3;
       mono = 7; 
       font8x8 = 256;

       { Bildschirmfarben, Vorder- und Hintergrund }
       black = 0;
       blue = 1;
       green = 2;
       cyan = 3;
       red = 4;
       magenta = 5;
       brown = 6;
       lightgray = 7;
       
       { nur Vordergrund }
       darkgray = 8;
       lightblue = 9;
       lightgreen = 10;
       lightcyan = 11;
       lightred = 12;
       lightmagenta = 13;
       yellow = 14;
       white = 15;

       { Blinkflag }
       blink = $80;

    var
       { aus Kompatibilittsgrnden: }
       checkbreak,checkeof,checksnow : boolean;
       
       { wenn true, wird von screeensetcursor die Graphikkarte }
       { direkt programmiert				       }
       directvideo : boolean;

       lastmode : word; { Bildschirmmodus }
       textattr : byte; { Textattribut }
       windmin : word; { Rechte obere Ecke des definierten Fensters }
       windmax : word; { Linke untere Ecke des definierten Fensters }

    function keypressed : boolean;
    function readkey : char;
    procedure gotoxy(x,y : byte);
    procedure window(left,top,right,bottom : byte);
    procedure clrscr;
    procedure textcolor(color : Byte);
    procedure textbackground(color : Byte);
    procedure assigncrt(var f : text);
    function wherex : byte;
    function wherey : byte;
    procedure delline;
    procedure delline(line : byte);
    procedure clreol;
    procedure insline;
    procedure cursoron;
    procedure cursoroff;
    procedure cursorbig;
    procedure lowvideo;
    procedure highvideo;
    procedure nosound;
    procedure sound(hz : word);
    procedure delay(ms : word);
    procedure textmode(mode : integer);
    procedure normvideo;
    
  implementation
  
    var
       maxcols,maxrows : longint;
  
    type
       pword = ^word;
        
       textbuf = array[0..127] of char;

       textrec = record
          handle : word;
          mode : word;
          bufSize : word;
          { private : word; PRIVATE ist Schluesselwort }
          _private : word;
          bufpos : word;
          bufend : word;
          bufptr : ^textbuf;
          openfunc : pointer;
          inoutfunc : pointer;
          flushfunc : pointer;
          closefunc : pointer;
          userdata : array[1..16] of byte;
          name : string[79];
          buffer : textbuf;
       end;
       
    var
       screenprimary : longint;
  
    { Low-Level Routinen: }
    
    {$i modes.inc}
    
    function getscreenprimary : longint;
    
      begin
         asm
            movl _ScreenPrimary,%eax
            leave
            ret
         end ['EAX'];
      end;
      
    function screenrows : byte;
    
      begin
         asm
            movb 0xe0000484,%al
            incb %al
            leave
            ret
         end ['EAX'];
      end;
      
    function screencols : byte;
    
      begin
         asm
            movb 0xe000044a,%al
            leave
            ret
         end ['EAX'];
      end;
      
    procedure screensetcursor(row,col : longint);
    
      begin
         if directvideo then
           asm
              movzbw	8(%ebp),%ax
              movzbw	12(%ebp),%bx
              // neue DOS-Position setzen
              movb	%al,0xe0000451
              movb 	%bl,0xe0000450
              // Spaltenanzahl lesen
              movzbw	0xe000044a,%cx
              // Adressen berechnen
              imulw	%cx,%ax
              addw	%ax,%bx
              // direkte Zugriffe auf die Register der Graphikkarte:
              movw	$0x3d4,%dx
              movb	$0x0e,%al
              outb	%al,%dx
              movb	%bh,%al
              incw	%dx
              outb	%al,%dx
              decw	%dx
              movb	$0x0f,%al
              outb	%al,%dx
              movb	%bl,%al
              incw	%dx
              outb	%al,%dx
           end
         else 
            asm
               movb	$0x02,%ah
               movb	$0,%bh
	       movb	8(%ebp),%dh
    	       movb	12(%ebp),%dl
	       pushl	%ebp
	       int	$0x10
	       popl	%ebp
            end;
     end;
     
    procedure screengetcursor(var row,col : longint);

      begin
         asm
	    movl	12(%ebp),%ebx
	    movzbl	0xe0000450,%eax
	    movl	%eax,(%ebx);
	    movl	8(%ebp),%ebx
	    movzbl	0xe0000451,%eax
	    movl	%eax,(%ebx);
	 end ['EAX','EBX'];
      end;

    function vidaddr(row,col : byte) : pointer;

      begin
         vidaddr:=pointer(screenprimary+((row-1)*maxcols+(col-1))*2);
      end;
      
    {Exportierte Routinen: }
      
    procedure cursoron;
    
      begin
         asm
            movb   $1,%ah
            movb   $10,%cl
            movb   $9,%ch
            pushl %ebp
            int   $0x10
            popl %ebp
         end;
      end;
   
    procedure cursoroff;
    
      begin
         asm
            movb   $1,%ah
            movb   $-1,%cl
            movb   $-1,%ch
            pushl %ebp
            int   $0x10
            popl %ebp
         end;
      end;
   
    procedure cursorbig;
   
      begin
         asm
            movb   $1,%ah
            movb   $10,%cl
            movb   $1,%ch
            pushl %ebp
            int   $0x10
            popl %ebp
         end;
      end;
      
    var
       is_last : boolean;
       last : char;

    function readkey : char;
    
      var
         char2 : char;
         char1 : char;
    
      begin
         if is_last then
           begin
              is_last:=false;
              readkey:=last;
           end
         else
           begin
              asm
                 movb $0,%ah
                 pushl %ebp
                 int $0x16
                 popl %ebp
                 movw %ax,-2(%ebp)
              end;
              if char1=#0 then
                begin
                   is_last:=true;
                   last:=char2;
                end;
              readkey:=char1;
           end;
      end;
  
    function keypressed : boolean;
    
      begin
         if is_last then
           begin
              keypressed:=true;
              exit;
           end
         else
           asm
              movb $1,%ah
              pushl %ebp
              int $0x16
              popl %ebp
              setnz %al
              leave
              ret
           end;
      end;

   procedure gotoxy(x,y : byte);
   
     begin
        if (x<1) then
          x:=1;
        if (y<1) then
          y:=1;
        if y+hi(windmin)-2>=hi(windmax) then
          y:=hi(windmax)-hi(windmin)+1;
        if x+lo(windmin)-2>=lo(windmax) then
          x:=lo(windmax)-lo(windmin)+1;
        screensetcursor(y+hi(windmin)-1,x+lo(windmin)-1);
     end;

   function wherex : byte;

     var
        row,col : longint;

     begin
        screengetcursor(row,col);
        wherex:=col-lo(windmin)+1;
     end;

   function wherey : byte;

     var
        row,col : longint;

     begin
        screengetcursor(row,col);
        wherey:=row-hi(windmin)+1;
     end;

   procedure window(left,top,right,bottom : byte);

     begin
        if (left<1) or
           (right>screencols) or
           (bottom>screenrows) or
           (left>right) or
           (top>bottom) then
           exit;
        windmin:=(left-1) or ((top-1) shl 8);
        windmax:=(right-1) or ((bottom-1) shl 8);
        gotoxy(1,1);
     end;

   procedure clrscr;

     var
        fil : word;
        row : longint;

     begin
        fil:=32 or (textattr shl 8);
        for row:=hi(windmin) to hi(windmax) do
          fillword(vidaddr(row+1,lo(windmin)+1)^,lo(windmax)-lo(windmin)+1,fil);
        gotoxy(1,1);
     end;

   procedure textcolor(color : Byte);

     begin
        textattr:=(textattr and $70) or color;
     end;

   procedure lowvideo;

     begin
        textattr:=textattr and $f7;
     end;

   procedure highvideo;

     begin
        textattr:=textattr or $08;
     end;

   procedure textbackground(color : Byte);

     begin
        textattr:=(textattr and $8f) or ((color and $7) shl 4);
     end;

   var
      startattrib : word;

   procedure normvideo;

     begin
        textattr:=startattrib;
     end;

   procedure delline(line : byte);

     var
        row,left,right,bot : longint;
        fil : word;

     begin
        row:=line+hi(windmin);
        left:=lo(windmin)+1;
        right:=lo(windmax)+1;
        bot:=hi(windmax)+1;
        fil:=32 or (textattr shl 8);
        while (row<bot) do
          begin
             move(vidaddr(row+1,left)^,vidaddr(row,left)^,(right-left+1)*2);
             inc(row);
          end;
        fillword(vidaddr(bot,left)^,right-left+1,fil);
     end;

   procedure delline;

     begin
        delline(wherey);
     end;

   procedure insline;

     var
        row,col,left,right,bot : longint;
        fil : word;

     begin
        screengetcursor(row,col);
        inc(row);
        left:=lo(windmin)+1;
        right:=lo(windmax)+1;
        bot:=hi(windmax);
        fil:=32 or (textattr shl 8);
        while (bot>row) do
          begin
             move(vidaddr(bot-1,left)^,vidaddr(bot,left)^,(right-left+1)*2);
             dec(bot);
          end;
        fillword(vidaddr(row,left)^,right-left+1,fil);
     end;

   procedure clreol;

     var
        row,col : longint;
        fil : word;

     begin
        screengetcursor(row,col);
        inc(row);
        inc(col);
        fil:=32 or (textattr shl 8);
        fillword(vidaddr(row,col)^,lo(windmax)-col+2,fil);
     end;

   procedure crtinoutfunc(var f : textrec);

      var
         i,col,row : longint;
         c : char;
         va : pointer;
         sa : word;

      begin
    	 screengetcursor(row,col);
    	 inc(row);
    	 inc(col);
    	 va:=vidaddr(row,col);
         if f.mode=fmoutput then
           begin
              for i:=0 to f.bufpos-1 do
                begin
                   c:=f.buffer[i];
                   case ord(c) of
                      10 : begin
                              inc(row);
                              va:=va+maxcols*2;
                           end;
                      13 : begin
                              col:=lo(windmin)+1;
                              va:=vidaddr(row,col);
                          end;
                      8 : if col>lo(windmin)+1 then
                            begin
                               dec(col);
                               va:=va-2;
                            end;
                      7 : begin
                              { Piepsen }
                           end;
                   else
                      begin
                         sa:=textattr shl 8 or ord(c);
                         pword(va)^:=sa;
                         inc(col);
                         va:=va+2;
                      end;
                   end;
                   if col>lo(windmax)+1 then
                     begin
                        col:=lo(windmin)+1;
                        inc(row);
                        { neue Adresse kann in diesem Fall ohne   }
                        { groe Geschwindigkeitseinbuen komplett }
                        { berechnet werden                        }
                        va:=vidaddr(row,col);
                     end;
                   while row>hi(windmax)+1 do
                     begin
                        delline(1);
                        dec(row);
                        va:=va-maxcols*2;
                     end;
                end;
              f.bufpos:=0;
              screensetcursor(row-1,col-1);
           end
         {!!!!!!}
         else halt(100);
      end;

   procedure assigncrt(var f : text);

     begin
        textrec(f).inoutfunc:=@crtinoutfunc;
        textrec(f).flushfunc:=@crtinoutfunc;
     end;

   procedure sound(hz : word);

     begin
        if hz=0 then
          begin
             nosound;
             exit;
          end;
        asm
           movzwl 8(%ebp),%ecx
           movl $1193046,%eax
           cdql
           divl %ecx
           movl %eax,%ecx
           movb $0xb6,%al
           outb %al,$0x43
           movb %cl,%al
           outb %al,$0x42
           movb %ch,%al
           outb %al,$0x42
           inb $0x61,%al
           orb $0x3,%al
           outb %al,$0x61
        end ['EAX','ECX','EDX'];
     end;

   procedure nosound;

     begin
        asm
           inb $0x61,%al
           andb $0xfc,%al
           outb %al,$0x61
        end ['EAX'];
     end;

   var
      calibration : longint;

   procedure delay(ms : word);

      var
         i,j : longint;

     begin
        for i:=1 to ms do
          for j:=1 to calibration do
             begin
             end;
     end;

  procedure initdelay;

    var
       first : word;
       ticks : ^word;

    begin
       calibration:=0;
       ticks:=pointer($e000046c);
       { auf ticks-Wechsel warten }
       first:=ticks^;
       while ticks^=first do
         begin
         end;
       first:=ticks^;
       { Calibration schtzen }
       while ticks^=first do
         inc(calibration);
       { in entsprechende ms umrechnen }
       calibration:=calibration div 70;
       while true do
         begin
            first:=ticks^;
            while ticks^=first do
              begin
              end;
            first:=ticks^;
            delay(55);
            if first=ticks^ then
               exit
            else begin
                    { Calibration um mindestens 2% erniedrigen }
                    calibration:=calibration-calibration div 50;
                    dec(calibration);
                 end;
         end;
    end;

  procedure textmode(mode : integer);

    var
       set_font8x8 : boolean;

    begin
       lastmode:=mode;
       set_font8x8:=(mode and font8x8)<>0;
       mode:=mode and $ff;
       setscreenmode(mode);
       windmin:=0;
       windmax:=(screencols-1) or ((screenrows-1) shl 8);
       maxcols:=screencols;
       maxrows:=screenrows;
    end;

var
   col,row : longint;

begin
   is_last:=false;
   { Adresse des Bildschirmspeichers in Variable laden }
   screenprimary:=getscreenprimary;
   { direkter Bildspeicherzugriff }
   directvideo:=true;
   { Ausgabefenster setzen }
   windmin:=0;
   windmax:=(screencols-1) or ((screenrows-1) shl 8);
   { Systemvariablen in temp. Speicher laden, wegen Geschw. }
   maxcols:=screencols;
   maxrows:=screenrows;
   { nun noch die Daten zum wiederherstellen des Startstatuses }
   { speichert                                                 }
   screengetcursor(row,col);
   startattrib:=pword(vidaddr(row+1,col+1)+1)^;
   lastmode:=getscreenmode;
   textattr:=startattrib;
   { nun Standartausgabe auf CRT-Ausgaberoutine umleiten }
   assigncrt(output);
   { nun noch Delaykalibration berechnen }
   initdelay;
end.
