UNIT PIC256;
{
  PIC256
  - by Bjarke Viksoe

  Converts a PCPAINT / Pictor picture at 320x200 pixels
  in 256 colours to a raw picture.
  No IO checking. Compressed or not. But picture-file MUST be less than
  65535 bytes long!
}

INTERFACE

USES
	DEMOINIT, PICTURE;


Procedure ConvertPIC(dst : pScreen; src : pBuffer; filesize : longint);
Procedure LoadPix(buffer : pScreen; filename : string);


(*--------------------------------------*)

IMPLEMENTATION

TYPE
	pHeader = ^HeaderType;
	HeaderType = RECORD
		mark    : word;
		xsize   : word;
		ysize   : word;
		xoff    : word;
		yoff    : word;
		bitsinf : byte;
		emark   : byte;
		evideo  : byte;
		edesc   : word;
		esize   : word;
	end;


Procedure ExtractCMAP(v : pBuffer; i : word);
Var
	j : word;
Begin
	for j:=1 to 256*3 do begin
		cmap[j]:=v^[i] DIV 4;
		inc(i);
	end;
End;


Procedure DecompressPIC(src : pBuffer; dst : pScreen; numblks : word);
Var
	blksize : word;
Begin
	Asm
		push	ds
		les	di,[dst]
		lds	si,[src]
		cld
@blockloop:
		lodsw                {get block data size}
		lodsw
		mov	bx,ax
		lodsb
		mov	dl,al          {store block marker}
@inner_loop:
		lodsb
		cmp	al,dl
		je		@marker
		stosb
		dec	bx
		jnz	@inner_loop
		jmp	@block_done
@marker:
		lodsb
		or		al,al
		jz		@word_fill
		xor	ch,ch
		mov	cl,al
		sub	bx,cx
		lodsb
		rep stosb
		or		bx,bx
		jnz	@inner_loop
		jmp	@block_done
@word_fill:
		lodsw
		mov	cx,ax
		sub	bx,cx
		lodsb
		rep stosb
		or		bx,bx
		jnz	@inner_loop
@block_done:
		dec	[numblks]
		jnz	@blockloop
		pop	ds
	End;
End;

Procedure ConvertPIC(dst : pScreen; src : pBuffer; filesize : longint);
Var
	h : pHeader;
	i : longint;
	numblks : word;
Begin
	h := pHeader(src);
	with h^ do begin
		if (mark<>$1234) then exit;
		if (xsize>320) OR (ysize>240) OR (bitsinf<>8) OR (Chr(evideo)<>'L') then exit;
		if (emark<>$FF) then exit; {must have extra block in header}
	end;
	i:=SizeOf(HeaderType) + (h^.esize) + 1;
	if (h^.edesc=4) then ExtractCMAP(src, SizeOf(HeaderType)+1 );
	numblks:=(src^[i]) + (src^[i+1]*256);
	Inc(i, 2);
	if (numblks>0) then
		DecompressPIC(@src^[i],dst,numblks)
	else
		Move( src^[i], dst^, (h^.xsize * h^.ysize) );
end;


Procedure LoadPix(buffer : pScreen; filename : string);
Var
	pFileMem: pBuffer;
	FileHandle : file;
	size : longint;
Begin
	Assign(FileHandle, filename);
	Reset(FileHandle, 1);
	size := FileSize(FileHandle);
	if size > 65535 then exit;
	if size > MaxAvail then exit;
	GetMem(pFileMem, size);
	BlockRead(FileHandle, pFileMem^, size);
	Close(FileHandle);
	if IOResult=0 then
		ConvertPIC(buffer, pFileMem, size);
	FreeMem(pFileMem, size);
End;


End.
