PROGRAM Example6;

{Another example how to use an image as a scrolling background; this time, }
{a 8x4 tile image will be used, but pasted to the same area as in the pre- }
{vious example!}
{Just for the case that you are bored, this example also shows how to "tie"}
{output of OutTextXY() and sprites to an absolute screen position (in      }
{scrolling mode, of course, because otherwise it would be trivial)}

{$X+} {to ignore results of functions}
USES ANIVGA,CRT;
CONST TileName1='black.COD';     {1 black tile}
      TileName2='marmor.COD';    {32 tiles, captured from Win3.1}
      tiles_per_row=8;           {These are the proportions of }
      tiles_per_column=4;        {the above 4 tile file: 2x2!  }
      SpriteName='flower.COD';
      FlowerLoadNumber=1;        {load number for sprite}
      Flower1=0;                 {sprite number}
      Flower2=1;                 {another one  }
      ch:Char=#0;

PROCEDURE Init;
VAR gx,gy,count:INTEGER;
    Row:WORD;
BEGIN
 XTiles:=0; YTiles:=0;
 SetBackgroundMode(scrolling);
 SetBackgroundScrollRange(50,50,300,100);

 {paste tiles into this background, using circular enumeration}
 count:=0; Row:=0;
 gy:=BackY1;
 REPEAT
  gx:=BackX1;
  REPEAT
   PutTile(gx,gy,succ(count + (Row MOD tiles_per_column)*tiles_per_row));
   inc(count); count:=count MOD tiles_per_row;
   inc(gx,16);
  UNTIL gx>BackX2;
  inc(Row); {or: Row:=(Row+1) MOD tiles_per_row}
  inc(gy,16);
 UNTIL gy>BackY2;

 {load sprite:}
 IF loadSprite(SpriteName,FlowerLoadNumber)=0
  THEN BEGIN
        WRITELN('Couldn''t access file '+SpriteName+' : '+GetErrorMessage);
        halt(1)
       END;
END;

BEGIN
 Init;
 InitGraph;
 LoadTile(TileName1,0); {load the black tile as tile #0 = surrounding pattern}
 IF Error<>Err_None
  THEN BEGIN
        CloseRoutines;
        WRITELN('Couldn''t access file '+TileName1+' : '+GetErrorMessage);
        halt(1)
       END;
 LoadTile(TileName2,1); {load the 4 tiles as tile #1..4 = inner picture}
 IF Error<>Err_None
  THEN BEGIN
        CloseRoutines;
        WRITELN('Couldn''t access file '+TileName2+' : '+GetErrorMessage);
        halt(1)
       END;

 SetCycleTime(0); {animation as fast as possible}

 SpriteN[Flower1]:=FlowerLoadNumber;
 SpriteX[Flower1]:=0;
 SpriteY[Flower1]:=0;
 SpriteN[Flower2]:=FlowerLoadNumber;
 SpriteX[Flower2]:=StartVirtualX+100; {tie 2nd flower to absolute position}
 SpriteY[Flower2]:=StartVirtualY+100;

 Animate;
 OutTextXY(StartVirtualX+10,StartVirtualY+10,1-PAGE,'This text won''t scroll!');
 {show text the 1st time!}
 REPEAT
  IF Hitdetect(Flower1,Flower2) THEN BEGIN sound(1000); delay(5); nosound END;
  if KeyPressed
   THEN BEGIN
         WHILE KeyPressed DO ch:=Upcase(ReadKey);
         CASE ch OF
          'I':dec(SpriteY[Flower1]);  {change position of sprite with I,J,K,M}
          'J':dec(SpriteX[Flower1]);
          'K':inc(SpriteX[Flower1]);
          'M':inc(SpriteY[Flower1]);
          'E':dec(StartVirtualY,10);  {change position of whole scene with}
          'S':dec(StartVirtualX,10);  {E,S,D,X}
          'D':inc(StartVirtualX,10);
          'X':inc(StartVirtualY,10);
         END;
         IF POS(ch,'IJKMESDX')>0
          THEN BEGIN {=only if something changed}
                SpriteX[Flower2]:=StartVirtualX+100;
                SpriteY[Flower2]:=StartVirtualY+100;
                Animate; 
                OutTextXY(StartVirtualX+10,StartVirtualY+10,1-PAGE,
                          'This text won''t scroll!')
               END
        END;

 UNTIL (ch='Q') OR (ch=#27);  {"Q" or ESC to quit}

 CloseRoutines;

END.
