% "sieve.t" uses the sieve of Eratosthenes to identify prime numbers
% in the range 1..N.  This method originated in the 3rd century B.C.

const N : int := 1000
var a : array( N ) of boolean

program

    var i, j : int 

    init_a

    for i := 2...floor( N/2 ) do
        for j := 2...floor( N/i ) do
            a( i * j - 1 ) := false
        end for
    end for  

    for i := 1 ... N do
        if a( i - 1 ) then
            put i : 8...
        end if
    end for

    put ""
    put "All done!"

end program

procedure init_a

    var i : int

    for i := 1 ... N do
        a( i - 1 ) := true
    end for

end init_a


