include qlib.inc
include file.inc
include string.inc
include key.inc
include irq.inc

;parts copied from key.asm in "\lib\src"
align 4
;16 per line!
toascii db 0,27,'1234567890-=',14,15                      ;0
        db 'qwertyuiop[]',13,25,'as'                      ;16
        db 'dfghjkl;''`',22,'\zxcv'                       ;32
        db 'bnm,./',23,'*',24,' ',0,1,2,3,4,5             ;48
        db 6,7,8,9,10,0,0,18,88h,20,'-',84h,26,86h,'+',19 ;64
        db 82h,21,16,17,0,0,0,11,12,0,0,0,0,0,0,0         ;80
        db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0                ;96
        db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0                ;112

temp db 0,0
print1 proto,off:dword

tp dd ?
tx dw ?
ty dw ?
on db ?
q db 0 ;quit?
dis db 1   ;disable CTRL+BRK and CTRL+ALT+DEL
pp db 0

setmode proc,a:word   ;I don't want to link in the whole video stuff just 
  mov ax,a                                ;for setgmode so I made this...
  int 10h
  ret
setmode endp

main proc
  callp setmode,3
  callp setcursor,512  ;no cursor!
  callp print,"Testing KBD ... Press F1+F2 to quit\n"
  callp printf,"Block CTRL+BREAK and CTRL+ALT+DEL :          (SPACE to toggle)"
  callp gotoxy,0,22
  callp printf,"getch:"
  callp key_lights,0  ;shut off lights
  .if eax
     callp printf,"KBD error: Unable to send data to kbd\n"
     callp exit,0
  .endif
  jmp prn_dis
top:
  call getch
  .if al
    mov bl,al
    callp gotoxy,pp,23
    callp printf,"%c",bl
    inc pp
    .if pp>79
      mov pp,0
    .endif
    .if bl==32
      xor dis,1
prn_dis:
      callp key_block,dis
      callp gotoxy,36,1
      .if dis
        callp printf,"enabled "
      .else
        callp printf,"disabled"
      .endif
      jmp top
    .endif
  .endif
  mov tx,8  ;X pos
  mov ty,5  ;Y pos
  mov tp,0  ;offset (counter)
  mov q,0
@@:
  mov ebx,tp
  mov al,key_tab[ebx]  ;is it on?
  mov dl,key_tab1[ebx]  ;w/o e0h prefix
  mov dh,key_tab2[ebx]  ;w/  e0h prefix
  mov cl,toascii[ebx]   ;what is it?
  mov bx,dx
  .if ((cl>32)&&(cl<128))
    mov temp,cl
    .if cl=='+'
      callp gotoxy,71,6
    .elseif cl=='-' && tp==74
      callp gotoxy,71,5
    .elseif cl=='*'
      callp gotoxy,69,5
    .elseif
      callp gotoxy,tx,ty
    .endif
    mov on,bl
    callp print1,offset temp
    .if cl=='/'
      mov on,bh
      callp gotoxy,67,5
      callp print1,offset temp
    .endif
  .else
    ;specials based on al
    .if bl
      mov on,1
    .else
      mov on,0
    .endif
    .if cl==1
      .if bx
        inc q
      .endif
      callp gotoxy,5,4
      callp print1,"F1"
    .elseif cl==2
      .if bx
        inc q
      .endif
      callp gotoxy,8,4
      callp print1,"F2"
    .elseif cl==3
      callp gotoxy,11,4
      callp print1,"F3"
    .elseif cl==4
      callp gotoxy,14,4
      callp print1,"F4"
    .elseif cl==5
      callp gotoxy,17,4 
      callp print1,"F5"
    .elseif cl==6
      callp gotoxy,20,4
      callp print1,"F6"
    .elseif cl==7
      callp gotoxy,23,4
      callp print1,"F7"
    .elseif cl==8
      callp gotoxy,26,4
      callp print1,"F8"
    .elseif cl==9
      callp gotoxy,29,4
      callp print1,"F9"
    .elseif cl==10
      callp gotoxy,32,4
      callp print1,"F10"
    .elseif cl==11
      callp gotoxy,35,4
      callp print1,"F11"
    .elseif cl==12
      callp gotoxy,38,4
      callp print1,"F12"
    .elseif cl==13
      mov on,bl
      callp gotoxy,40,7
      callp print1,"Enter"
      mov on,bh
      callp gotoxy,71,9
      callp print1,"Enter"
    .elseif cl==14
      callp gotoxy,40,5
      callp print1,"BS"
    .elseif cl==15
      callp gotoxy,1,6
      callp print1,"Tab"
    .elseif cl==16
      mov on,bh
      callp gotoxy,46,5
      callp print1,"Ins"
      mov on,bl
      callp gotoxy,65,9
      callp print1,"0"
    .elseif cl==17
      mov on,bh
      callp gotoxy,46,6
      callp print1,"Del"
      mov on,bl
      callp gotoxy,69,9
      callp print1,"."
    .elseif cl==18
      mov on,bh
      callp gotoxy,50,5
      callp print1,"Home"
      mov on,bl
      callp gotoxy,65,6
      callp print1,"7"
    .elseif cl==19
      mov on,bh
      callp gotoxy,50,6
      callp print1,"End"
      mov on,bl
      callp gotoxy,65,8
      callp print1,"1"
    .elseif cl==20
      mov on,bh
      callp gotoxy,54,5
      callp print1,"PgUp"
      mov on,bl
      callp gotoxy,69,6
      callp print1,"9"
    .elseif cl==21
      mov on,bh
      callp gotoxy,54,6
      callp print1,"PgDn"
      mov on,bl
      callp gotoxy,69,8
      callp print1,"3"
    .elseif cl==22
      callp gotoxy,1,8
      callp print1,"L.Shft"
    .elseif cl==23
      callp gotoxy,40,8
      callp print1,"R.Shft"
    .elseif cl==24
      mov on,bl
      callp gotoxy,8,9
      callp print1,"Alt"
      mov on,bh
      callp gotoxy,35,9
      callp print1,"Alt"
    .elseif cl==25
      mov on,bl
      callp gotoxy,2,9
      callp print1,"Ctrl"
      mov on,bh
      callp gotoxy,39,9
      callp print1,"Ctrl"
    .elseif cl==26
      callp gotoxy,67,7 ;keypad 5
      callp print1,"5"
    .elseif cl==27
      callp gotoxy,1,4
      callp print1,"ESC"
    .elseif cl==32
      callp gotoxy,12,9
      callp print1," --- Space Bar --- "
    .elseif cl==88h
      mov on,bh
      callp gotoxy,50,8
      callp print1,"Up"
      mov on,bl
      callp gotoxy,67,6
      callp print1,"8"
    .elseif cl==82h
      mov on,bh
      callp gotoxy,50,9
      callp print1,"Dn"
      mov on,bl
      callp gotoxy,67,8
      callp print1,"2"
    .elseif cl==84h
      mov on,bh
      callp gotoxy,44,9
      callp print1,"Left"
      mov on,bl
      callp gotoxy,65,7
      callp print1,"4"
    .elseif cl==86h
      mov on,bh
      callp gotoxy,53,9
      callp print1,"Right"
      mov on,bl
      callp gotoxy,69,7
      callp print1,"6"
    .endif
  .endif
  add tx,2
  .if tx>34
    mov tx,8
    inc ty
  .endif
  inc tp
  cmp tp,128
  jnz @b
  .if q==2
    callp setmode,3
    ret
  .endif
  mov tp,0
  jmp top
main endp

temp2 db 80 dup (?)

print1 proc uses ecx ebx,off:dword
  ;must preserve BX
  .if on==1
    callp strcpy,offset temp2,off
  .else
    callp strlen,off
    mov ecx,eax
    mov edi,offset temp2
    mov al,32
    rep stosb
    mov al,0
    stosb
  .endif
  callp print,offset temp2
  ret
print1 endp

end
