/* ;FILE I/O !  protos  */

#ifndef __FILE_H__
#define __FILE_H__

struct ffblk {
  byte ff_reserved[21]; /* reserved by DOS */
  byte ff_attrib;       /* attribute found */
  word ff_ftime;        /* file time */
  word ff_fdate;        /* file date */
  dword ff_fsize;        /* file size */
  byte ff_name[13];     /* found file name */
};

extern sword open(byte *strg,byte acc);
extern void close(word hand);
extern word creat(byte *strg,word attr);
extern sdword read(word hand,void* buf,dword len);
extern sdword write(word hand,void* buf,dword len);
extern sdword lseek(word hand,dword pos,byte typ);
extern tell(word hand);
extern filelength(word hand);
extern eof(word hand);
extern unlink(byte * strg);
extern getdisk();
extern setdisk(byte drv);
extern mkdir(byte * strg);
extern chdir(byte * strg);
extern rmdir(byte * strg);
extern rename(byte * old,byte * new);
extern getcwd(byte * buf);
extern getdcwd(byte drv,byte * buf);
extern findfirst(byte* str1,word attr,void * ffb);
extern findnext(void* ffb);

extern word ferror;

extern sbyte pack_init(word siz1);
extern sbyte pack_open(byte *strg);

#define SEEK_SET 0   // Seeks from beginning of file
#define SEEK_CUR 1   // Seeks from current position
#define SEEK_END 2   // Seeks from end of file

#define O_BINARY   0        // Binary mode                                 
#define O_RDONLY   0        // Read only                                   
#define O_WRONLY   1        // Write only                                  
#define O_RDWR     2        // Read and write                              
#define O_APPEND   4        // File pointer will be set to the end of file 
#define O_CREAT    8        // Creates the file if it doesn't exist        
#define O_TRUNC    16       // Truncate the file when open                 
#define O_EXCL     32       // Returns an error if file exists (O_CREAT)

#define FA_NORMAL   0x00        /* Normal file, no attributes */
#define FA_RDONLY   0x01        /* Read only attribute */
#define FA_HIDDEN   0x02        /* Hidden file */
#define FA_SYSTEM   0x04        /* System file */
#define FA_LABEL    0x08        /* Volume label */
#define FA_DIREC    0x10        /* Directory */
#define FA_ARCH     0x20        /* Archive */

#endif
