#include <qlib.h>
#include <file.h>
#include <string.h>

byte fixer;

struct bufs{
  byte fn[13];  //0-12
  word fh;      //always 0
  dword off;    //offset
  dword siz;    //size of file
} sample;

struct bufs *buf;

dword coff;  //current offset
word cbuf;
dword siz;
int hi,ho,t;
byte str[80];
#define tbufsiz 16*1024
byte tbuf[tbufsiz];
dword a;
word cnt;
dword head=0x1a4b4150;   //"PAK",26

void readln (void) {
  byte s=0,t;
  memset(str,0,19);
  while (!eof(hi)) {
    read(hi,&t,1);
    if (t==0xa) break;
    if (t!=0xd) str[s++]=t;
  }
  str[s]=0;
}

struct ffblk ff;

void main(byte argc,byte **args) {

  dword siz;

  if (argc!=2) {
    printf(" PACKIT v2.0 (32bit)\n");
    printf(" Usage: PACKIT fileout\n");
    printf("  Packs *.* into fileout (do not put fileout in cur dir)\n");
    exit(0);
  }

  buf=malloc(sizeof(sample)*65000);
  if ( ((dword)buf)==ERROR) {
    printf("Out of ram...\n");
    abort();
  }

  coff=0;    //current offset
  cbuf=0;    //current buffer

  printf("Gathering file info...");
  findfirst("*.*",FA_ARCH,&ff);
  while (1) {
    strcpy(str,ff.ff_name);
    t=open(str,O_BINARY);
    if (t==-1) {
      printf("Unable to open:%s",str);
      exit(0);
    }
    siz=filelength(t);
    memset(buf[cbuf].fn,0,13);
    strcpy(buf[cbuf].fn,str);
    buf[cbuf].fh=0;
    buf[cbuf].off=coff;
    buf[cbuf].siz=siz;
    close(t);
    cbuf++;
    if (cbuf>=65000) {
      printf("File limit: 65000 files");
      abort();
    }
    coff+=siz;
    if (findnext(&ff)) break;
  }
  printf("# files found=%d\n",cbuf);

  ho=open(args[1],O_BINARY|O_CREAT|O_TRUNC|O_RDWR);

  if (ho==-1) {
    printf("File io error"); exit(0);
  }

  write(ho,&head,4);

  write(ho,&cbuf,2);
  buf[cbuf].fn[0]=0;
  /* now create packfile output
  format =
    filename [13]
    handle [2]  ;not used in file
    offset [4]
    size [4]
  */
  a=6+cbuf*23;
  cbuf=0;
  while(buf[cbuf].fn[0]){
    buf[cbuf].off+=a;
    write(ho,&buf[cbuf],sizeof(buf[0]));
    cbuf++;
  }
  //output the actual files!
  cbuf=0;
  while(buf[cbuf].fn[0]){
    hi=open(buf[cbuf].fn,O_BINARY|O_RDONLY);
    while (1) {
      a=read(hi,tbuf,tbufsiz);
      if (!a) break;
      write(ho,tbuf,a);
    }
    close(hi);
    printf("%s - done!\n",buf[cbuf].fn);
    cbuf++;
  }
  close(hi);
  printf("\n all done!!\n");
}