; TASM defines for PMC v1.01 by Tran (a.k.a Thomas Pytel).

; Segment defines

segment	_TEXT dword public use32 'CODE'
ends	_TEXT

segment	_DATA dword public use32 'DATA'
ends	_DATA

segment	_BSS  dword public use32 'BSS'
ends	_BSS

group	DGROUP	_DATA, _BSS
assume  cs:_TEXT, ds:DGROUP, es:DGROUP, ss:DGROUP

macro	segTEXT
segment	_TEXT dword public use32 'CODE'
assume  cs:_TEXT, ds:DGROUP, es:DGROUP, ss:DGROUP
endm

macro	segDATA
segment	_DATA dword public use32 'DATA'
endm

macro	segBSS
segment	_BSS dword public use32 'BSS'
endm


; Basic types

NULL            = 0
FALSE           = 0
TRUE            = 1


; General macros

macro	rlp	reg,p
        mov &reg,&p
        sub &reg,[database]
endm

macro	lnp	reg,p
        mov &reg,&p
        add &reg,[database]
endm

macro	dcp	reg,p
        mov &reg,&p
        add &reg,[code_data]
endm

macro	cdp	reg,p
        mov &reg,&p
        add &reg,[data_code]
endm


; Memory and addresses

struc		SEGOFF
sgoff           dw      ?
sgseg           dw      ?
ends

struc		SELOFF
sloff           dd      ?
slsel           dw      ?
ends

struc		MEMBLOCK
mbbase          dd      ?
mbsize          dd      ?
mbhandle        dd      ?
ends

struc		WALKMBINF
wmbiadx         dd      ?
wmbisize        dd      ?
wmbiflags       db      ?
ends


; Selectors and descriptors

struc		DESCRIPTOR
dsclimit_l      dw      ?
dscbase_l       dw      ?
dscbase_m       db      ?
dscaccess       dw      ?
dscbase_h       db      ?
ends


; Register data structure

struc		REGSTRUCT
label		rsEDI   dword
rsDI            dw      ?,?
label		rsESI   dword
rsSI            dw      ?,?
label		rsEBP   dword
rsBP            dw      ?,?
rsRESERVED      dd      ?
label		rsEBX	dword
label		rsBX    word
rsBL            db      ?
rsBH            db      ?,?,?
label		rsEDX   dword
label		rsDX    word
rsDL            db      ?
rsDH            db      ?,?,?
label		rsECX   dword
label		rsCX    word
rsCL            db      ?
rsCH            db      ?,?,?
label		rsEAX   dword
label		rsAX    word
rsAL            db      ?
rsAH            db      ?,?,?
rsFLAGS         dw      ?
rsES            dw      ?
rsDS            dw      ?
rsFS            dw      ?
rsGS            dw      ?
label		rsCSIP  dword
rsIP            dw      ?
rsCS            dw      ?
label		rsSSSP  dword
rsSP            dw      ?
rsSS            dw      ?
ends

fCF             = 0001h
fPF             = 0004h
fAF             = 0010h
fZF             = 0040h
fSF             = 0080h
fIF             = 0200h
fDF             = 0400h
fOF             = 0800h
fSTD            = fCF or fPF or fZF or fSF or fOF


; System variables, directly accessible in real mode in DATA

global c   codebase       : dword
global c   database       : dword
global c   pspbase        : dword
global c   envbase        : dword
global c   codesel        : dword
global c   datasel        : dword
global c   pspsel         : dword
global c   envsel         : dword
global c   zerosel        : dword
global c   _TEXTseg       : dword
global c   _DATAseg       : dword
global c   _BSSseg        : dword
global c   pspseg         : dword
global c   envseg         : dword
global c   zeroptr        : dword
global c   data_code      : dword
global c   code_data      : dword
       
global c   osversion      : dword
global c   osminor        : byte
global c   osmajor        : byte
global c   DPMIversion    : dword
global c   DPMIminor      : byte
global c   DPMImajor      : byte
       
global c   CPL            : dword
global c   selinc         : dword
global c   PMtype         : dword
global c   processor      : dword
global c   PICtable       : byte
global c   PICmaster      : byte
global c   PICslave       : byte

global c   rmstate        : dword
global c   rmswitch       : dword
global c   pmstate        : fword
global c   pmswitch       : fword
global c   statesize      : dword

global c   pmcrmnoregs    : dword
global c   pmcrmregs      : dword
global c   pmcrminoregs   : dword
global c   pmcrmiregs     : dword
global c   rmcpmnoregs    : dword
global c   rmcpmregs      : dword
global c   rmcpminoregs   : dword
global c   rmcpmiregs     : dword

global c   pmstacklen     : dword
global c   pmstackbase    : dword
global c   pmstacktop     : dword
global c   rmstacklen     : dword
global c   rmstackbase    : dword
global c   rmstacktop     : dword

global c   lowheapblock   : dword
global c   extheapblock   : dword
global c   rs             : dword

; Possibly above first 64k of DATA, not accessible directly in real mode

global c   _PMpagetables  : dword
global c   _PMselectors   : dword
global c   _PMrmstacklen  : dword
global c   _PMpmstacklen  : dword
global c   _PMrmstacks    : dword
global c   _PMpmstacks    : dword
global c   _PMcallbacks   : dword
global c   _pmcrmstacklen : dword
global c   _pmcrmstacks   : dword
global c   _rmcpmstacklen : dword
global c   _rmcpmstacks   : dword
        
global c   _stklen        : dword
global c   _lowheaplen    : dword
global c   _extheapmin    : dword
global c   _extheapmax    : dword
global c   _minosversion  : dword
global c   _lowbufptr     : dword
global c   _lowbuflen     : dword


; DPMI function error codes

_DPMI09ERROR            = -32768

_DPMIUNSUPPORTED        = -32767
_DPMIBADSTATE           = -32766
_DPMISYSINTEGRITY       = -32765
_DPMIDEADLOCK           = -32764
_DPMICANCELLED          = -32763

_DPMINORESOURCE         = -32752
_DPMINODESCRIPTOR       = -32751
_DPMINOLINEARMEM        = -32750
_DPMINOPHYSICALMEM      = -32749
_DPMINOBACKINGSTORE     = -32748
_DPMINOCALLBACK         = -32747
_DPMINOHANDLE           = -32746

_DPMILOCKEXCEEDED       = -32745
_DPMIRESOURCEEXCLUSIVE  = -32744
_DPMIRESOURCESHARED     = -32743

_DPMIBADVALUE           = -32735
_DPMIBADSELECTOR        = -32734
_DPMIBADHANDLE          = -32733
_DPMIBADCALLBACK        = -32732
_DPMIBADLINEARADDRESS   = -32731
_DPMIBADREQUEST         = -32730

; DOS function error codes

_DOSBADFUNCTION         = -65535
_DOSBADFILE             = -65534
_DOSBADPATH             = -65533
_DOSNOHANDLES           = -65532
_DOSACCESSDENIED        = -65531
_DOSBADHANDLE           = -65530
_DOSNOMEM               = -65528
_DOSBADENV              = -65526
_DOSBADFORMAT           = -65525
_DOSBADACCESSCODE       = -65524
_DOSBADDRIVE            = -65521
_DOSCURRENTDIR          = -65520
_DOSNOTSAMEDEVICE       = -65519
_DOSNOMOREFILES         = -65518

; File open mode codes

RDONLY                  = 0
WRONLY                  = 1
RDWR                    = 2

; File seek from codes

SEEK_SET                = 0
SEEK_CUR                = 1
SEEK_END                = 2

; File find attributes and mode

FA_NORMAL               = 000h
FA_RDONLY               = 001h
FA_HIDDEN               = 002h
FA_SYSTEM               = 004h
FA_LABEL                = 008h
FA_DIREC                = 010h
FA_ARCH                 = 020h

FF_FIRST                = 04eh
FF_NEXT                 = 04fh

; IRQ mask values

IRQENABLED              = 0
IRQDISABLED             = 1

; Code stub types

RMSTUBINRI              = 0
RMSTUBINRC              = 1
RMSTUBFNRI              = 2
RMSTUBFNRC              = 3
RMSTUBIRI               = 4
RMSTUBIRC               = 5
RMSTUBFRI               = 6
RMSTUBFRC               = 7

RMSTUBNRLEN             = 020h
RMSTUBRLEN              = 0c0h
PMSTUBLEN               = 048h
CBSTUBLEN               = 038h

; IRQ types

IRQI                    = 0
IRQC                    = 1
IRQOWN                  = 2

IRQILEN                 = RMSTUBNRLEN
IRQCLEN                 = RMSTUBNRLEN + PMSTUBLEN
IRQOWNLEN               = 0

