/*
 * WND.H - Kirjaston rakennekuvaukset
 * Sislt toisen osan muutokset (uusi vr(), wprintfx jne.)
 *
 */

#define VRAM    0xb8000000
#define putfast(x, y, col, ch) *((int far *)VRAM+((y)*80)+(x))=(ch)+((col)<<8)
#define getfast(x, y) *((int far *)VRAM+((y)*80)+(x))

typedef struct field {
    int x;          /* FLDX     kentn x-koordinaatti        */
    int y;          /* FLDY     kentn y-koordinaatti        */
    int w;          /* FLDW     kentn leveys */
    char *buff;
    struct field *fnxt;
    struct field *fprv;
} FIELD;

typedef struct _wnd {
    int x;          /* XC       ikkunan x-koordinaatti */        /* WPRNTF */
    int y;          /* YC       ikkunan y-koordinaatti */        /* WPRNTF */
    int w;          /* WC       ikkunan leveys */                /* WPRNTF */
    int h;          /* HC       ikkunan korkeus */               /* WPRNTF */
    int nx;         /* NX       relatiivisen kursorin x */       /* WPRNTF */
    int ny;         /* NY       relatiivisen kursorin y */       /* WPRNTF */
    int c;          /* COL      ikkunan normaali piirtovri */   /* WPRNTF */
    int col[4];     /* COL[]    ikkunan erikoisvrit */
    int border;     /* BORDER   onko reuna */
    int btype;      /* BTYPE    border type -- minklainen kehys */
    int visible;    /* VISIBLE  onko ikkuna esill nkyviss */
    char *title;    /* TITLE    otsikko */
    char *buf;      /* BUF      taustan sislt */
    struct _wnd *_nx;
    struct _wnd *_pv;
    FIELD *_fh;
    FIELD *_ft;
    int maxfield;
} WND;

#define FALSE   0
#define TRUE    1

#define FHEAD   (wnd->_fh)
#define FTAIL   (wnd->_ft)

/* Prototyyppej: */

WND *wdef(int x, int y, int w, int h, int border);
void wcol(WND *wnd, int where, int col);
void wbrd(WND *wnd, int btype);
void wopen(WND *wnd);
void wclose(WND *wnd);
void wcursor(WND *wnd, int x, int y);
void wtitle(WND *wnd, char *s);
void dtitle(WND *wnd);
void wframe(WND *wnd);
void vrstr(WND *wnd);
void wdraw(WND *wnd);
void vram(WND *wnd, int status);
void wdraw(WND *wnd);
void wremove(WND *wnd);
void wprint(WND *wnd, int x, int y, int c, char *txt, ...);
void wprintf(WND *wnd, char *txt, ...);
void print(int x, int y, int col, char *ln, ...);
void paint_chr(int x, int y, int w, int h, int col, int ch);
char *waddr(WND *wnd, int x, int y);
void paint_att(int x, int y, int w, int h, int col);
void vs(int x, int y, int w, int h, char *buf);
void vr(WND *wnd, int x, int y, int w, int h, char *buf);
void putwindow(WND *wnd, int x, int y, int col, char chr);
int buffget(WND *wnd, int x, int y);
void wprintfx(WND *wnd, char *ln, ...);
void scroll_up(WND *wnd);

/* Puolifunktiot : */

#define wborder(wnd,bt) wnd->btype=bt

/* Muut definet : */

#define OK      0
#define ERROR   -1

#define XC      (wnd->x)
#define YC      (wnd->y)
#define WC      (wnd->w)
#define HC      (wnd->h)
#define NX      (wnd->nx)
#define NY      (wnd->ny)
#define COL     (wnd->c)
#define BUF     (wnd->buf)
#define BTYPE   (wnd->btype)
#define VISIBLE (wnd->visible)
#define TITLE   (wnd->title)
#define BRDCOL  (wnd->col[0])
#define TTLCOL  (wnd->col[1])
#define RVRCOL  (wnd->col[2])
#define TXTCOL  (wnd->col[3])
#define BORDER  (wnd->border)
#define NEXT    (wnd->_nx)
#define PREV    (wnd->_pv)

#define BRD 0
#define TTL 1
#define RVR 2
#define TXT 3
#define ALL 4
#define TRN 256

enum ramfunc { SAVE, RESTORE };
