/*------------------------------------------------------------------------*/
/* dstruct.h */
 
typedef int (*cmp_func)(const void *, const void *);
 
typedef struct node {
    struct node *prev;
    struct node *next;
    void *data;     /* pointer to user's data */
    char flags;
#define FREEABLE    01  /* is `data' free()-able memory? */
#define LIST_HEADER 02  /* is this a header node in a list? */
} NODE;
 
#define PREORDER    1
#define INORDER     2
#define POSTORDER   3
 
NODE *node_init(void *data, size_t size, int flags);
void node_free(NODE *);
void tree_insert(NODE **root, NODE *new);
NODE *tree_ord_add(NODE **root, NODE *new, int uniq, cmp_func cmp);
void tree_free(NODE *root);
NODE *tree_find(NODE *root, void *data, int order, cmp_func cmp);
NODE *tree_walk(NODE *root, int order, int (*action)(NODE *));
 
NODE *list_new(void);
void list_free(NODE *hdr);
int list_is_empty(NODE *hdr);
void list_insert(NODE *after, NODE *new);
NODE *list_unlink(NODE *n);
void list_remove(NODE *n);
NODE *list_walk(NODE *first, int (*visit)(NODE *));


/* Linkitettyjen listojen ksittely. */
 
#include <stdlib.h>
#include <stdio.h>
#include "dstruct.h"
 
/* Luo uusi lista, eli sen tunnussolmu. */
NODE *list_new(void) {
    NODE *n = node_init((void *)0, 0, 0);
    if (n != NULL) {
        n->next = n->prev = n;
        n->flags |= LIST_HEADER;
    }
    return n;
}
 
/* Tuhoa lista tunnussolmuineen. */
void list_free(NODE *hdr) {
    NODE *n, *nn;
    while (!list_is_empty(hdr)) /* Poistetaan ensin data-solmut */
        list_remove(hdr->next);
    node_free(hdr);         /* ... ja sitten tunnussolmu */
}
 
/* Onko lista tyhj? */
int list_is_empty(NODE *hdr) {
    return hdr->next == hdr;
}
 
/* Lis uusi solmu vanhan solmun jlkeen. */
void list_insert(NODE *after, NODE *new) {
    new->next = after->next;    /* uuden solmun linkit */
    new->prev = after;
    after->next = new;      /* edellisest eteenpin uuteen */
    new->next->prev = new;      /* ja seuraavasta taaksepin */
}
 
/* Irroita solmu listasta siirtelemll linkkej. */
NODE *list_unlink(NODE *n) {
    n->prev->next = n->next;
    n->next->prev = n->prev;
    n->next = n->prev = NULL;
    return n;
}
 
/* Poista solmu: irroita listasta ja vapauta muistitila */
void list_remove(NODE *n) {
    node_free(list_unlink(n));
}
 
/* Ky lpi listaa loppuun asti. */
NODE *list_walk(NODE *first, int (*visit)(NODE *)) {
    NODE *n;
 
    for (n = first; !(n->flags & LIST_HEADER); n = n->next)
        if ((*visit)(n))
            return n;
    return NULL;
}


/*------------------------------------------------------------------------*/
/* node.c */
 
#include <stdlib.h>
#include <stddef.h>
#include <string.h>
 
#include "dstruct.h"
 
NODE *node_init(void *data, size_t size, int flags) {
    NODE *n;
 
    n = (NODE *) malloc(sizeof(NODE));
    if (n == NULL)
        return NULL;
 
    if (size == 0)
        n->data = data;
    else {
        n->data = (void *) malloc(size);
            free(n);
            return NULL;
        }
        flags |= FREEABLE;
        if (data != NULL)
            memcpy(n->data, data, size);
    }
 
    n->flags = flags;
    n->prev = n->next = NULL;
    return n;
}
 
void node_free(NODE *n) {
    if (n != NULL) {
        if (n->flags & FREEABLE && n->data != NULL)
            free(n->data);
        free(n);
    }
}


/*------------------------------------------------------------------------*/
/* Listojen esittelyohjelma: lue lukuja, tulosta knteisess
jrjestyksess
*/
 
#include <stdio.h>
#include <stdlib.h>
 
#include "dstruct.h"
 
int tulosta(NODE *n) {      /* tulosta solmun data */
    printf("%d\n", *(int *)n->data);
    return 0;
}
 
int main(void) {
    NODE *tunnari, *n;
    int i;
 
    tunnari = list_new();   /* luo lista */
        printf("ei onnistu listan luominen\n");
        exit(1);
    }
 
    while (scanf("%d", &i) == 1) {
        /* luo solmu jonka datana on juuri luettu luku */
        n = node_init(&i, sizeof(int), 0);
        if (n == NULL) {
            printf("ei onnistu solmun luominen\n");
            exit(1);
        }
 
        /* lis alkuun, eli tunnussolmun jlkeen */
        list_insert(tunnari, n);
    }
 
    list_walk(tunnari->next, tulosta);
    exit(0);
}
