/*
 * DISKER  Levykkeill olevien tiedostojen indeksointiin tarkoitettu
 *         apuohjelma. (c) Copyright 1991 Harri Talvitie.
 *
 *         Lhdekoodi sopii sellaisenaan Turbo C(++):lle. Microsoft C:t
 *         ja muita varten tulee muuttaa joidenkin header-tiedostojen ja
 *         kirjastofunktioiden nimet.
 *
 */

#include <stdio.h>
#include <ctype.h>              /* Sislt mm. toupper proton/makron */
#include <dir.h>                /* Sislt mm. ffblk mrittelyn */
#include <dos.h>                /* Sislt mm. int86:n proton */
#include <conio.h>              /* Sislt mm. clrscr proton */
#include <stdlib.h>             /* Sislt mm. atoi:n proton */

/**** Omien funktioiden prototyypit: ****/

void paavalikko(void);          /* Valitaan toiminto */
void lisaa_levyja(void);        /* Listn levyj tietokantaan */
int haluaako_levyn(void);       /* Luetaanko seuraava levyn tiedot */
void nayta_levyn_tiedot(int disknum, long diskfree);
                                /* Nytetn luetun levyn tiedot */
char levyvalinta(void);         /* Valitaan levylle tehtv toimenpide */
long vapaana(char levy);        /* Paljonko levyll on tilaa jljell */
int uusi_numero(int valmis);    /* Muodostetaan levylle uusi numero */
char hae_paavalinta(void);      /* Haetaan pvalikon valinta */
void hae_nimet(void);           /* Haetaan levyll olevien tiedostojen nimet */
void etsi_tietoja(void);        /* Etsitn tiedostonimi */
void lisaa_tiedot(int disknum, long diskfree);
                                /* Listn tiedot tietokantaan */
int highest(void);              /* Korkeimman levyn numero tietokannassa */
int lue_levynro(char levy);     /* Luetaan levyn numero */

/*** Mrittelyj: ***/

#define ESC     27              /* ESC-nppimen scan-koodi */
#define TRUE    1               /* Boolean TRUE */
#define FALSE   0               /* Boolean FALSE */
#define LEVY    'A'             /* Kytss oleva levyasema. */
   /* Voitaisiin mys toteuttaa esim. komentoriviparametrina */

char filenames[512][80];        /* Tiedostonimet. Sarjassa "Quick and dirty" */
int fnc = 0;                    /* FileNameCount eli tiedostojen lukumr */

/****************************************************************************/

void main()
{
    paavalikko();
}

void paavalikko(void)
{
    char valinta;

    for (;;) {
        valinta = hae_paavalinta();
        switch (valinta) {              /* Ksitelln valinta */
            case 'L':
                lisaa_levyja();         /* Listn levyj tietokantaan */
                break;
            case 'E':
                etsi_tietoja();
                break;
            case 'Q':                   /* Lopetus */
            case ESC:
                break;
            default:
                break;
        }
        if (valinta == 'Q' || valinta == ESC)
            break;          /* Poistuminen ikuisesta silmukasta */
    }
}

char hae_paavalinta(void)
{
    char valinta;

    clrscr();       /* Tyhjennetn ruutu */
    printf("** Disker v1.0 **\n\n");
    printf("<L> ... Sytetn lis levykkeit\n");
    printf("<E> ... Etsi tietoja\n");
    printf("<Q> ... Lopetus\n\n");

    for (;;) {
        printf("Mik on valintasi: ");
        valinta = toupper(get_char());
        if (valinta != 'L' && valinta != 'E' && valinta != 'Q' &&
            valinta != ESC && valinta != '\r') {
                printf("\a\nVirheellinen valinta. "
                        "Paina L, <ENTER>, E, Q tai <ESC>\n");
        } else
            break;
    }
    if (valinta == '\r')    /* Enter on sama kuin L eli lisys */
        valinta = 'L';
    printf("%c\n", valinta);
    return valinta;
}

void lisaa_levyja(void)
{
    int disknum = 0, ehdotus = 0;
    long diskfree;
    char valinta;

    clrscr();       /* Tyhjennetn nytt */
    printf("Listn/pivitetn tietoja\n");

    for (;;) {
        if (haluaako_levyn() == FALSE)
            return;         /* Kyttj painoi 'Q' */
        hae_nimet();        /* Luetaan levyn sislt */
        disknum = lue_levynro(LEVY);    /* Luetaan label */
        diskfree = vapaana(LEVY);       /* Paljonk on vapaata tilaa */
        nayta_levyn_tiedot(disknum, diskfree);
        ehdotus = 0;
        if (disknum == 0) {     /* Levyll ei ole numeroa */
            ehdotus = disknum = highest();
            printf("\nLevyll ei ole numeroa. "
            " Ehdotus uudeksi numeroksi: %d.\n", ehdotus);
        }
        printf("\n<CR>: lis levy %d, <U> Anna uusi numero ja lis sitten, "
            "<Q> l lis: ", disknum);

        valinta = levyvalinta();

        switch(valinta) {   /* Ksitelln valinta */
            case 'L':       /* Listn tmn levyn tiedot */
                if (ehdotus)
                    disknum = uusi_numero(ehdotus);
                lisaa_tiedot(disknum, diskfree);
                break;
            case 'U':       /* Haluttiin antaa uusi numero */
                disknum = uusi_numero(0);
                printf("Listn levyn %d tiedot\n", disknum);
                lisaa_tiedot(disknum, diskfree);
                break;
            case 'Q':       /* Ei list tietoja */
                printf("Tietoja ei listty\n");
                break;
        }
    }
}

int haluaako_levyn(void)
{
    char painallus;

    for (;;) {
        printf("\n--> Laita levy %c-asemaan ja paina <ENTER> kun olet valmis, "
            "<Q> lopettaa: ", LEVY);
        painallus = toupper(get_char());
        if (painallus != 'Q' && painallus != '\r') {
            printf("\a");     /* Painoi vr nppint => nimerkki */
            continue;
        }
        if (painallus == 'Q') {
            clrscr();
            return FALSE;
        } else {
            printf("<CR>\n");
            return TRUE;
        }
    }
}

void nayta_levyn_tiedot(int disknum, long diskfree)
{
    int i, j, ehdotus;

    printf("\nLevyn numero: %d  Vapaata tilaa: %ld\n\n", disknum, diskfree);
    for (i = 0; i < fnc; i++) {
        printf("%s", filenames[i]);
        for (j=0;j<20-strlen(filenames[i]);j++)
            printf(" ");        /* Muodostetaan nelj palstaa */
    }
    printf("\n");
}

char levyvalinta(void)
{
    char valinta;

    for (;;) {
        valinta = toupper(get_char());
        if (valinta != '\r' && valinta != 'Q' && valinta != 'U') {
            printf("\nVirheellinen valinta. Paina <ENTER>, 'Q' tai 'U': ");
            continue;
        }
        if (valinta == '\r')
            valinta = 'L';
        else
            valinta = toupper(valinta);
        printf("%c\n", valinta);
        break;
    }
    return valinta;
}

void lisaa_tiedot(int disknum, long diskfree)
/*
 * Listn tiedot tietokantaan.
 *
 */
{
    FILE *fp;
    int i, len;
    char tmp[30], fooline[256];

    sprintf(tmp,"%d.DSK", disknum);

    if (access(tmp, 0) == 0) {
        /*
         * Jos levylle on jo olemassa sisllysluettelotiedosto avataan se.
         */
        fp = fopen(tmp, "r");
        fgets(fooline, 256, fp);    /* Hyptn ensimmisen rivin ylitse */
        while (fgets(fooline, 256, fp) != NULL) {
            if (fooline[strlen(fooline)-1] == '\n')
                fooline[strlen(fooline)-1] = '\0';
            for (i=0;fooline[i] != ' ' && fooline[i] != '\0';i++)
                ;
            len = i;
            for (i = 0; i < fnc; i++) {
                if (strnicmp(filenames[i], fooline, len) == 0)
                    strcpy(filenames[i], fooline);
            }
        }
        fclose(fp);
    }

    if ( (fp = fopen(tmp, "w") )) {
            /* Muodostetaan uusi sisllysluettelotiedosto */
        fprintf(fp, "Levy %d  Vapaana: %ld\n", disknum, diskfree);
        printf("Levy %d  Vapaana: %ld\n", disknum, vapaana(LEVY));
        for (i = 0; i < fnc; i++)
            fprintf(fp, "%s\n", filenames[i]);
        fclose(fp);
    } else {
        printf("Virhe tietojen pivittmisess\n");
    }
}

int uusi_numero(int valmis)
{
    int disknum = 0;
    char cmdline[40], antoi[10];

    if (!valmis) {
        printf("\nAnna levylle uusi numero: ");
        gets(antoi);
        disknum = atoi(antoi);
    } else
        disknum = valmis;

    sprintf(cmdline, "LABEL %c:%d", LEVY, disknum);
        /* Kirjoitetaan levyn numero labeliksi */
    system(cmdline);
    return disknum;
}

void hae_nimet(void)
{
    char dirn[255][15], mask[15];
    struct ffblk ffblk;
    int dirs = 0, done = 0, i;

    fnc = 0;
    sprintf(mask, "%c:\\*.*", LEVY);
    done = findfirst(mask, &ffblk, FA_DIREC);
    while (!done) {
        if (ffblk.ff_attrib == FA_DIREC && ffblk.ff_name[0] != '.') {
            strcpy(dirn[dirs++], ffblk.ff_name);
        } else if (ffblk.ff_name[0] != '.')
            sprintf(filenames[fnc++], "%s%c%ld", ffblk.ff_name, 255,
                ffblk.ff_fsize);
        done = findnext(&ffblk);
    }

    for (i = 0; i < dirs; i++) {
        /*
         * Kydn lvitse phakemiston alla olleet alihakemistot
         * (mutta ei niiden alla olevia!)
         */
        sprintf(mask, "%c:\\%s\\*.*", LEVY, dirn[i]);
        done = findfirst(mask, &ffblk, 0);
        printf("Done = %d\n", done);
        while (!done) {
            sprintf(filenames[fnc++], "%s%c%ld", ffblk.ff_name, 255,
                ffblk.ff_fsize);
            done = findnext(&ffblk);
        }
    }
}

int lue_levynro(char levy)
/*
 * Luetaan levyn labelista numero
 */
{
    char tmp[20];
    struct ffblk ffblk;

    sprintf(tmp, "%c:\\*.*", levy);
    if (!findfirst(tmp, &ffblk, FA_LABEL))
        return(atoi(ffblk.ff_name));
    else
        return 0;
}

void etsi_tietoja(void)
{
    printf("\n\aEi ole viel toteutettu tss versiossa!");
    delay(2500);        /* 2.5 sek tauko */
}

int highest(void)
/*
 * Palauttaa korkeimman .DSK-tiedoston numeroarvon
 */
{
    struct ffblk ffblk;
    int done;
    int high = 0;

    done = findfirst("*.DSK", &ffblk, 0);
    while (!done) {
        if (high < atoi(ffblk.ff_name))
            high = atoi(ffblk.ff_name);
        done = findnext(&ffblk);
    }
    return high+1;
}

int get_char(void)
/*
 * Odottaa nppinpainallusta ja palauttaa sen. Toimii mys
 * non-ASCII nppimille (esim. erilaiset ALT/CTRL-yhdistelmt)
 * jotka palautetaan lismll varsinaiseen scan-arvoon 1000.
 *
 */
{
    int     scan, asci, c;
    union   REGS rg;

    while (1) {
        rg.h.ah = 1;
        int86(0x16, &rg, &rg);
        if (rg.x.cflag & 0x40) {
            int86(0x28, &rg, &rg);
            continue;
        }
        rg.h.ah = 0;
        int86(0x16, &rg, &rg);
        scan = rg.h.ah;
        asci = rg.h.al;
        if (asci == 0)
            c = scan + 1000;
        else
            c = asci;
        break;
    }
    return c;
}

long vapaana(char levy)
/*
 * Palauttaa levylla "levy" vapaana olevien tavujen lukumrn.
 *
 */
{
    struct dfree dtable;

    getdfree(levy - 64, &dtable);
    return ((long)dtable.df_avail * (long)dtable.df_bsec *
            (long)dtable.df_sclus);
}
