VERSION 2.00
Begin Form Form1 
   BorderStyle     =   1  'Fixed Single
   Caption         =   "KwikZone"
   ClientHeight    =   2205
   ClientLeft      =   3885
   ClientTop       =   3750
   ClientWidth     =   5265
   FontBold        =   -1  'True
   FontItalic      =   0   'False
   FontName        =   "Times New Roman"
   FontSize        =   8.25
   FontStrikethru  =   0   'False
   FontUnderline   =   0   'False
   Height          =   2610
   Icon            =   ZONE.FRX:0000
   Left            =   3825
   LinkMode        =   1  'Source
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   ScaleHeight     =   2205
   ScaleWidth      =   5265
   Top             =   3405
   Width           =   5385
   Begin CommandButton idd_help 
      Caption         =   "&HELP!!!"
      Height          =   315
      Left            =   2760
      TabIndex        =   4
      Top             =   1860
      Width           =   2475
   End
   Begin CommandButton idd_exit 
      Caption         =   "&Exit"
      Height          =   315
      Left            =   30
      TabIndex        =   3
      Top             =   1860
      Width           =   2685
   End
   Begin ListBox CityListBox 
      Height          =   1200
      Left            =   45
      TabIndex        =   7
      TabStop         =   0   'False
      Top             =   465
      Width           =   1860
   End
   Begin PictureBox Picture1 
      BorderStyle     =   0  'None
      Height          =   525
      Left            =   4590
      Picture         =   ZONE.FRX:0302
      ScaleHeight     =   525
      ScaleWidth      =   600
      TabIndex        =   5
      Top             =   60
      Width           =   600
   End
   Begin TextBox code 
      Height          =   315
      Left            =   1425
      TabIndex        =   1
      Top             =   90
      Width           =   480
   End
   Begin Timer Timer1 
      Interval        =   1000
      Left            =   3615
      Top             =   45
   End
   Begin Label timezone 
      AutoSize        =   -1  'True
      Height          =   195
      Left            =   3210
      TabIndex        =   6
      Top             =   1140
      Width           =   75
   End
   Begin Label Label2 
      AutoSize        =   -1  'True
      Caption         =   "Time Zone:"
      Height          =   195
      Left            =   1980
      TabIndex        =   2
      Top             =   1140
      Width           =   975
   End
   Begin Label StateCode 
      Height          =   210
      Left            =   3210
      TabIndex        =   9
      Top             =   870
      Width           =   495
   End
   Begin Label Label3 
      AutoSize        =   -1  'True
      Caption         =   "State Code:"
      Height          =   195
      Left            =   1980
      TabIndex        =   8
      Top             =   870
      Width           =   1020
   End
   Begin Label StateName 
      AutoSize        =   -1  'True
      Height          =   195
      Left            =   3210
      TabIndex        =   11
      Top             =   585
      Width           =   675
   End
   Begin Label Label4 
      AutoSize        =   -1  'True
      Caption         =   "State Name:"
      Height          =   195
      Left            =   1980
      TabIndex        =   10
      Top             =   600
      Width           =   1065
   End
   Begin Label TimeLabel 
      Height          =   195
      Left            =   3255
      TabIndex        =   13
      Top             =   150
      Width           =   1185
   End
   Begin Label Label5 
      AutoSize        =   -1  'True
      Caption         =   "Current Time:"
      Height          =   195
      Left            =   1980
      TabIndex        =   12
      Top             =   150
      Width           =   1155
   End
   Begin Label Label1 
      AutoSize        =   -1  'True
      Caption         =   "&Area Code"
      Height          =   195
      Left            =   60
      TabIndex        =   0
      Top             =   150
      Width           =   900
   End
End
Dim Record As RecordType
Dim FileNum As Integer
Dim ClickCounter As Integer




'   FUNCTION:   CenterDialog (Form)
'
'   PURPOSE:    Centers the form whose name is the argument
'
'   ARGUMENTS:  Form name
'
Sub CenterDialog (A_Form As Form)
    Dim cLeft As Integer
    Dim cTop As Integer

    cLeft = (Screen.Width - A_Form.Width) / 2
    cTop = (Screen.Height - A_Form.Height) / 2

    A_Form.Move cLeft, cTop
End Sub

'   FUNCTION:   CleanList
'
'   PURPOSE:    Resets the values fields for
'                   CityListBox
'                   StateName.Caption
'                   StateCode.Caption
'                   TimeZone.Caption
'
'   ARGUMENTS:  None
'
Sub CleanList ()
    Do While CityListBox.ListCount
        CityListBox.RemoveItem 0
    Loop
    StateName.Caption = ""
    StateCode.Caption = ""
    TimeZone.Caption = ""
End Sub

Sub code_Change ()
    If Len(Code.Text) = 3 Then
        FindRecord (Code.Text)
    End If
End Sub

'   FUNCTION:   FindRecord (String)
'
'   PURPOSE:    Searches and retrieves a record information based on area code
'
'   ARGUMENTS:  Area code as STRING
'
'   RETURNS:    City names
'               State Name
'               State Code
'               Time Zone
'
Sub FindRecord (InputVal As String)
    TimeFactor = 0
    Found = 0
    Index% = 1
    Seek FileNum%, 1    'reset file counter
    CleanList           'clear list box and other data fields
    Do While Not EOF(FileNum%)
        Get FileNum%, Index%, Record
        If Record.AreaCode = InputVal Then  'Do we have a match?
            Found = 1
            CityListBox.AddItem Record.CityName
            StateName.Caption = Record.StateName
            TimeZone.Caption = Record.TimeZone
            StateCode.Caption = Record.StateCode
            Counter% = Index%
            Do While Not EOF(FileNum%)      'Keep searching until end of file
                Counter% = Counter% + 1
                Get FileNum%, Counter%, Record
                If Record.AreaCode = InputVal Then
                    CityListBox.AddItem Record.CityName
                End If
            Loop
            Code.SetFocus
            Code.SelStart = 0               'Hilight area CODE field for
            Code.SelLength = Len(Code.Text) 'next search string
            Exit Do
        Else
            Index% = Index% + 1
        End If
    Loop

    If EOF(FileNum%) And (Found = 0) Then   'Did we enter an invalid area code
        Beep                                'Sound BEEP and display message box
        MsgBox "Invalid area code was entered. Try again.", 64, "KwikZone"
        Code.SetFocus
        Code.SelStart = 0                   'Hilight area CODE field for
        Code.SelLength = Len(Code.Text)     'next search string
    End If
End Sub

'****************************************************************************
'
'   PROGRAM: KwikZone.
'
'   PURPOSE: Displays cities, state, and Time zone based on area code
'
'   FORMS:
'
'       HelpMe.FRM
'       About.FRM
'       Zone.FRM
'       KwikZone.BAS
'
'   Fuctions:
'
'       CenterDialog (A_Form AS Form)
'       CleanList ()
'       FindRecord (InputVal As String)
'       Initialize ()
'
Sub Form_Load ()
    Load Help
    Load About
    ChDir app.Path
    Initialize
    CenterDialog Form1
End Sub

Sub Form_Paint ()
    If Screen.ActiveForm.Caption = "KwikZone" Then
        Code.SetFocus
    End If
End Sub
                 

Sub Form_Unload (Cancel As Integer)
    End
End Sub

Sub idd_exit_Click ()
    Close FileNum%          'Close file handle before exiting
    End
End Sub

' Calls (unhides) the HELP dialog box.
'
Sub idd_help_Click ()
    CenterDialog Help
    Help.Show 1
End Sub

'   FUNCTION:   Initialize ()
'
'   PURPOSE:    Initializes values and pointers to data file
'
'   ARGUMENTS:  None
'
Sub Initialize ()
    NL$ = Chr$(13) + Chr$(10)
    Static Record As RecordType
    RecordLen% = Len(Record)        'Define record length
    FileNum% = FreeFile
    Open "kwikzone.dat" For Random As FileNum% Len = RecordLen%   'Attempt to open file
    FileLength% = LOF(FileNum%)     'Define FileLength
    If (FileLength% = 0) Then       'If FileLength was Zero, then file not found
        Beep
        Msg$ = "Cannot find data file. KWIKZONE will terminate." + NL$ + NL$
        Msg$ = Msg$ + "Make sure KWIKZONE.DAT is in same directory as the executable file."
        MsgBox Msg$, 16, "KwikZone"
        Close FileNum%
        Kill "kwikzone.dat"
        End
    End If
End Sub

Sub Picture1_Click ()
    CenterDialog About
    About.Show 1
End Sub

'Updates the clock field and displays "AM" or "PM" as appropriate
'
Sub Timer1_Timer ()
    Dim MyTime As String
    Dim DayTime As String
    NL$ = Chr$(10) + Chr$(13)
    AppName$ = "KwikZone"

    MyTime = Time$
    Hours = Val(MyTime)
    If Hours > 12 Then Mid$(MyTime, 1, 2) = Str$(Hours - 12)    'Convert 24-hour time into 12-hour

' Add AM or PM accordingly based on time of day
    If Hours > 12 Then
         DayTime = MyTime + " PM"
    Else
         DayTime = MyTime + " AM"
    End If

    TimeLabel.Caption = DayTime
    
' Add clock to caption if minimized
    If windowstate = 0 Then
        Form1.Caption = AppName$
    Else
        Form1.Caption = AppName$ + NL$ + DayTime
    End If
End Sub

