/* Copyright (C) 1992 by Thomas Glen Smith.	All Rights Reserved. */
/* tokcopy APL2 V1.0.0 *************************************************
* Called from funcopy to copy a token.							 *
***********************************************************************/
#define INCLUDES APLMEM+STRING+APLCB+APLCHDEF+APLTOKEN
#include "includes.h"
void tokcopy(totok,fromtok)
Apltoken totok,fromtok;
{
	Aplcopy; Execfree;
	Aplcb cb;
     char *cp;

	if (fromtok->token_queue.token_next_ptr == NULL)
		totok->token_queue.token_next_ptr = NULL; /* end of chain */
	else
		totok->token_queue.token_next_ptr = totok + 1;
	totok->token_code = fromtok->token_code;
	totok->token_offset = fromtok->token_offset;
	totok-> token_flags = TOKPERM; /* permanent token */
	switch (fromtok->token_code) {
		case QUOTE:
		case VECTOR_TOKEN:
			cb = totok->token_ptr.token_vector =
               	aplcopy(fromtok->token_ptr.token_vector);
			break;
		case OPERAND_TOKEN:
			cp = totok->token_ptr.token_string = malloc(
				strlen(fromtok->token_ptr.token_string)+1);
               if (cp == NULL) return;
			strcpy(cp,fromtok->token_ptr.token_string);
			break;
		default:
			totok->token_ptr.token_string = NULL;
			break;
	} /* end switch */
}
