/* Copyright (C) 1993 by Thomas Glen Smith.  All Rights Reserved. */
/* slashtra APL2 V1.0.0 ************************************************
* Called from execexee when the current token is either a slash,       *
* slash bar, slope, or slope bar to transform the token into a         *
* DERIVED_FUNCTION token.                                              *
***********************************************************************/
#define INCLUDES APLTOKEN+APLTOKCD+FUNSTRUC+APLDERIV+APLCB+TREE+FUNCODES
#include "includes.h"
int slashtra(tok)
Apltoken tok; /* token for slash, slash bar, slope, slope bar */
{
     Axistest;Execaxis;Execfree;Execgetp;Execnext;Newderiv;Slasherr;
     extern int aplerr,indxorg;
     extern Treelist treehdr;
     int noexit;
     Aplderiv dp=NULL;
     Apltoken axistok,funtok,op;
     Aplcb axcb=NULL, lcb=NULL;

     if (axistest(treehdr->avlexec->avloprst))
          axcb = execaxis(&(treehdr->avlexec->avloprst));
     treehdr->lastfun = 0; /* for execnext processing */
     noexit = execnext(&funtok,&axistok,&op,NULL);
     for (;;) { /* So I can use break. */
          if (op) { /* compress/expand */
               lcb = execgetp(op); /* save left opnd */
			op = NULL;
			if (lcb == NULL) break; /* m/b error. */
		}
          dp = newderiv(axcb, lcb, NULL);
          if (aplerr) break;
          dp->deriv_op = /* identifies slash or slope, and default axis */
               tok->token_ptr.token_function;
          if (lcb != NULL) /* compress/expand */
               slashtrb(tok,funtok,axistok,dp); /* compress/expand */
          else { /* reduce/scan */
               if (axistok) {
                    aplerr = 89; /* axis out of place */
                    break;
               }
               slashtrc(tok,funtok,dp);
          }
          return(noexit);
     }
     slasherr(funtok,axistok,op,dp);
     return(noexit);
}
