/* Copyright (C) 1994 by Thomas Glen Smith.	All Rights Reserved. */
/* reverse APL2 V1.0.0 *************************************************
* The result, k, is equal to the argument, x, except the items appear  *
* in reverse order.  The axis argument determines the axis over which  *
* vectors are reversed if x is of rank greater than 1.				 *
***********************************************************************/
#define INCLUDES APLCB
#include "includes.h"
Aplcb reverse(rite,axis)
Aplcb rite; /* variable to be reversed */
int axis; /* axis of reversal */
{
	Dtacopy; Errstop; Revrot;
	extern int indxorg;
	int a,axicnt,botcnt,datatyp,i,j,k,size,topcnt;
	char	*cia,*cib,*coa,*cob,*cop;
	Aplcb out=NULL;

	axis += (indxorg==0);
	if (NULL == (out=revrot(rite,axis,&axicnt,&botcnt,&topcnt)))
		return(errstop(0,NULL,rite,NULL));
	if (0 == out->aplcount) return(errstop(0,NULL,rite,out));
	datatyp = out->aplflags & (APLMASK + APLAPL);
	size = out->aplsize;
	a=botcnt*axicnt;
	for (i=0; i<topcnt; i++) {
		cia=rite->aplptr.aplchar+i*a*size;
		coa=out->aplptr.aplchar +i*a*size;
		for (j=0; j<botcnt; j++) {
			cib=cia+(j+a)*size;
			cob=coa+(j-botcnt)*size;
			for (k=axicnt; k>0; k--)
				cop = dtacopy(
				(cob+=botcnt*size),(cib-=botcnt*size),
				1, 1, datatyp);
		}
	}
	return(errstop(0,NULL,rite,out));
}
