/* Copyright (C) 1993 by Thomas Glen Smith.  All Rights Reserved. */
/* newtok APL2 V1.0.0 **************************************************
* Called to allocate a new token.                                      *
***********************************************************************/
#define INCLUDES APLMEM+APLTOKEN
#include "includes.h"
Apltoken newtok(parm_code,parm_flags,parm_offset,namebuf,namelen)
int parm_code, parm_flags, parm_offset; /* token code, flags, offset */
char *namebuf;                /* name buffer */
int namelen;                  /* length of name buffer */
{
     Chrcopy; Execfree;
     extern int aplerr;
     Apltoken new;
     char *cp;

     if (aplerr) return(NULL);
     new = malloc(sizeof (struct apltoken));
     if (new == NULL) return(NULL); /* out of storage */
     new->token_flags = parm_flags;
     new->token_offset = parm_offset;
     new->token_code = parm_code;
     new->token_work = NULL;
     if (namebuf) {
          new->token_ptr.token_string = cp = malloc(namelen + 1);
          if (cp == NULL) { /* out of storage */
               execfree(new);
               return(NULL);
          }
          cp = chrcopy(cp,namebuf,namelen,1); /* copy name */
          *cp = '\0'; /* add delimiter */
     }
     else new->token_ptr.token_string = NULL;
     return(new);
}
