/* Copyright (C) 1995 by Thomas Glen Smith.  All Rights Reserved. */
/* nestchar APL2 V1.0.0 ************************************************
* Called by execqfx.  Converts the argument, which must be a nested    *
* vector of character vectors and scalars, to a character matrix.      *
***********************************************************************/
#define INCLUDES APLCB
#include "includes.h"
Aplcb nestchar(rite)
Aplcb rite;
{
	Chrcopy; Errstop; Getcb;
	extern int aplerr;
     Aplcb cb,*cbp,out=NULL;
	int cbcount,maxlen,thislen;
	static char blank=' ';
	char *op;

	cbp = rite->aplptr.aplapl; /* Ptr to cb for 1st line. */
	cbcount = rite->aplcount; /* Count of lines in Lcr. */
	maxlen = 0; /* Will be max line length. */
	while(cbcount--) {
		thislen = (*cbp++)->aplcount;
		if (thislen > maxlen) maxlen = thislen;
	}
	out = getcb(NULL,rite->aplcount * maxlen,APLCHAR + APLTEMP,2,NULL);
	if (out != NULL) {
		cbcount = rite->aplcount; /* Count of lines in Lcr. */
		*(out->apldim) = cbcount; /* Lines, or rows. */
		*(out->apldim+1) = maxlen; 
		/* Next, fill with blanks. */
		chrcopy(out->aplptr.aplchar,&blank,out->aplcount,0);
		cbp = rite->aplptr.aplapl; /* Ptr to cb for 1st line. */
		op = out->aplptr.aplchar; /* Start of 1st output line. */
		while(cbcount--) {
			cb = *cbp++; /* Cb for next line. */
			thislen = cb->aplcount;
			op = chrcopy(op, cb->aplptr.aplchar, thislen, 1);
			op += maxlen - thislen; /* Next output line. */
		}
	}
	return(errstop(0,NULL,rite,out));
}

