/* Copyright (C) 1996 by Thomas Glen Smith.	All Rights Reserved. */
/* matchokt APL2 V1.0.0 ************************************************
* Called by matchoks when conversion is necessary, and the desired	 *
* output data is numeric.									 *
***********************************************************************/
#define INCLUDES APLCB
#include "includes.h"
int matchokt(pleft,prite,datatyp,ltype,rtype)
Aplcb *pleft, *prite;
int datatyp,ltype,rtype;
{
	Complex; Integer; Real;
	extern int aplerr;
	Aplcb left, rite;

	left = *pleft;
	rite = *prite;
	if (((ltype | rtype) & APLCPLX) && (datatyp & APLCPLX)) {
		if (ltype != APLCPLX) *pleft = complex(left);
		if (rtype != APLCPLX) *prite = complex(rite);
	} else if (((ltype | rtype) & APLNUMB) && (datatyp & APLNUMB)) {
		if (ltype != APLNUMB) *pleft = real(left);
		if (rtype != APLNUMB) *prite = real(rite);
	} else if (((ltype | rtype) & APLINT)  && (datatyp & APLINT)) {
		if (ltype != APLINT) *pleft = integer(left);
		if (rtype != APLINT) *prite = integer(rite);
	} else if (datatyp & APLINT) {
		if (ltype != APLINT) *pleft = integer(left);
		if (rtype != APLINT) *prite = integer(rite);
	} else if (datatyp & APLNUMB) {
		if (ltype != APLNUMB) *pleft = real(left);
		if (rtype != APLNUMB) *prite = real(rite);
	} else if (datatyp & APLCPLX) {
		if (ltype != APLCPLX) *pleft = complex(left);
		if (rtype != APLCPLX) *prite = complex(rite);
	} else return(0); /* data not ok */
	return(aplerr == 0);
}
