/* Copyright (C) 1994 by Thomas Glen Smith.	All Rights Reserved. */
/* logx APL2 V1.0.0 ****************************************************
* Called by logrithx.  Logarithms for complex numbers.                 *
* For any s of magnitude p, angle q, the natural log of s, @s, is -    *
* @p+iXq, where -                                                      *
* i = square root of -1.                                               *
* s = a + bXi, a and b being real number coefficients.                 *
* p = dabsx(s) = magnitude.                                            *
* q = atan b%a = -7 O b%a                                              *
***********************************************************************/
#define INCLUDES MATH
#include "includes.h"
#define ABS(v) ((v) > 0e0 ? (v) : -(v))
void logx(num,ret)
double *num, *ret;
{
	Dabsx;
	static double pi = 3.14159265358979323846;
	static double halfpi = 1.570796632679489661923;
	static double iii[2]={0.0,1.0};
	extern double fuzz;
	double a, b, babs, p[2];

	a = *num;		/* Real part coefficient. */
	b = *(num+1);	/* Imaginary part coefficient. */
	babs = ABS(b);
	if (babs < fuzz && a > 0) { /* Imaginary part = 0. */
		*ret = log(a);
		*(ret+1) = 0e0;
	} else {
		dabsx(num,p);
		*ret = log(*p);
		if (a == 0e0)
			*(ret+1) = (b < 0e0) ? -halfpi : halfpi;
		else *(ret+1) = atan2(b,a);
	}
}
