/*Copyright (C) 1992, 1996 by Thomas Glen Smith.  All Rights Reserved.*/
/* iroll APL2 V1.0.0 ***************************************************
* Called by deal.                                                      *
* Returns a random selection from the whole numbers beginning with     *
* indxorg and ending with indxorg+n-1.  This version of iroll works    *
* the zortech C++ compiler.                                            *
***********************************************************************/
#define INCLUDES MATH
#include "includes.h"
int iroll(n)
int n;
{
	extern int aplerr;
	extern int indxorg;
#if APL_DOS
	double divisor=32767.0;
#else
	double divisor=RAND_MAX;
#endif

	if (n == 0) return(0);
	if (n < 0) {
		aplerr = 37;
		return(0);
	}
	return(indxorg + (int) (((double) rand())/divisor * (double) n));
}
