/* Copyright (C) 1994 by Thomas Glen Smith.	All Rights Reserved. */
/* inttran APL2 V1.0.0 *************************************************
* Called by integes.  Converts an array of double to int, using fuzz   *
* to adjust, e.g. a	double value 2 may really be stored as 1.9999...   *
***********************************************************************/
#define INCLUDES 0
#include "includes.h"
void inttran(to, from, count, incr)
int *to;	    /* Location of output integer array. */
double *from; /* Location of input double array. */
int count;    /* count of items to be translated. */
int incr;     /* 1 if input is array, 0 if input is single value */
{
	extern double fuzz;
	int j;
	double f,g;

	while(count--) {
		if (0.0 > (f = *from)) {
			if (f != (g = (j = f)))
				j--; /* next lower integer */
		}
		else j = (f + fuzz); /* e.g. 2 maybe 1.9... */
		*to++ = j;
          from += incr;
	}
}
