/* Copyright (C) 1994 by Thomas Glen Smith.	All Rights Reserved. */
/* indexgen APL2 V1.0.0 ************************************************
* For positive integer argument N, produces a vector of length N		 *
* containing the first N integers in order, beginning with the value	 *
* in indxorg.	Indexgen expects the argument to be a pointer to an	 *
* aplcb describing the integer N.								 *
***********************************************************************/
#define INCLUDES APLCB
#include "includes.h"
Aplcb indexgen(rite)
Aplcb rite;
{
	Errinit; Errstop; Indxsub; Ivalue; Mod;
	extern int aplerr;
	extern double fuzz;
	int datatyp,i;
	double dbl;

	for (;;) {
		if (errinit()) break;
		if (rite->aplcount != 1) break;
		if (0 == (i=rite->aplflags & (APLINT + APLNUMB))) break;
		if (i == APLINT)
			i = ivalue(rite);
		else { /* datatype is APLNUMB */
			if (0.0 > (dbl = *(rite->aplptr.apldata)))
               	if (-fuzz > dbl) break;
                    else i = 0;
               else if (mod(dbl,1.0) > fuzz) break;
			else i = dbl;
			endoper(rite);
		}
		if (i < 0) break; /* m/b positive integer */
		return(indxsub(i));
	}
	return(errstop(45,NULL,rite,NULL));
}
