/* Copyright (C) 1994 by Thomas Glen Smith.	All Rights Reserved. */
/* ibinomp APL2 V1.0.0 *************************************************
* The expression -											 *
* ifactorl(rite) / (ifactorl(left) * ifactorl(rite - left))			 *
* yields the equivalent to the binomial function.  For positive		 *
* arguments ibinom(m,n) yields the number of distinct ways in which	 *
* m things can be chosen from n things.							 *
***********************************************************************/
#define INCLUDES 0
#include "includes.h"
void ibinomp(m,n,ret)
int *m,*n,*ret;
{
	int den,i,j,k,mm,nn,num;

	if (*m == *n || *m == 0) {*ret = 1; return;}
	if (*n >= 0)
		if (*m > *n || *m < 0)
			{*ret = 0; return;}
		else;
	else /* n < 0 */
		if (*m < 0 && *m > *n)
			{*ret =0; return;}
	k = *n - *m;
	num = nn = *n;
	while(--nn > k) num *= nn;
	den = mm = *m;
	while(--mm > 1) den *= mm;
	*ret =(num/den);
}
