/* Copyright (C) 1995 by Thomas Glen Smith.  All Rights Reserved. */
/* gradesub APL2 V1.0.0 ************************************************
* Called by both grade when rite has rank greater than 1, and          *
* and recursively by itself.  Returns these values according to the    *
* comparison of the subarrays pointed to by a and b:                   *
* -1 if subarray a is less than subarray b.                            *
*  0 if subarray a is equal to subarray b.                             *
* +1 if subarray a is greater than subarray b.                         *
***********************************************************************/
#define INCLUDES APLCB
#include "includes.h"
int gradesub(rite,a,b,r)
Aplcb rite;	/* Variable being sorted. */
int a;		/* Index to subarray a. */
int b;		/* Index to subarray b. */
int r;		/* Number of items in subarray. */
{
	extern double fuzz;
	int *aip,*bip,i;
	double *adp,*bdp,d;

	switch(rite->aplflags & APL_NUMERIC) {
		case APLINT:
			aip = rite->aplptr.aplint + a*r;
			bip = rite->aplptr.aplint + b*r;
			while(r--) {
				i = *aip++ - *bip++;
				if (i > 0)
					return(1);	/* a > b */
				if (i < 0)
					return(-1);	/* a < b */
			}
			break;
		case APLNUMB:
			adp = rite->aplptr.apldata + a*r;
			bdp = rite->aplptr.apldata + b*r;
			while(r--) {
				d = *adp++ - *bdp++;
				if (d > fuzz)
					return(1);	/* a > b */
				if (d < -fuzz)
					return(-1);	/* a < b */
			}
	} /* End switch. */
	return(0); /* Get here only if subarrays are equal. */
}
