/*Copyright (C) 1992, 1995 by Thomas Glen Smith.  All Rights Reserved.*/
/* funcmsg APL2 V1.0.0 *************************************************
* Called by funcexef whenever an error occurs during function execution*
* to print error messages.                                             *
***********************************************************************/
#define INCLUDES APLCB+APLFUNCI+APLTOKEN+STDIO
#include "includes.h"
void funcmsg(fp,offset,stmtno)
struct aplfunc *fp; /* Function definition structure. */
int offset; /* Offset in statement where error occurred. */
int stmtno; /* Statement number in error. */
{
	Aplnewl; Execmsg;
	int stmtlen;
	Aplcb cb;

	stmtlen = *(fp->functext->apldim + 1);
	cb = fp->functext; /* Pointer to char representation aplcb. */
	if (cb->aplflags & APLAPL) {
		cb = *(cb->aplptr.aplapl+stmtno); /* aplcb for stmt in err. */
		execmsg(cb->aplptr.aplchar,cb->aplcount,offset,NULL);
	}
	else execmsg(cb->aplptr.aplchar + stmtno * stmtlen,
		stmtlen,offset,NULL);
	printf("The error occurred in function %s",
		fp->funcname->token_ptr.token_string);
	aplnewl(); /* Start a new output line. */
}
