/*Copyright (C) 1992, 1994 by Thomas Glen Smith.  All Rights Reserved.*/
/* funcexef APL2 V1.0.0 ************************************************
* Called by funcexee after stop control has been handled to execute    *
* the next function statement.                                         *
***********************************************************************/
#define INCLUDES APLCB+APLCHDEF+APLFUNCI+APLTOKEN+TREE
#include "includes.h"
int funcexef(trace,stmtno,fp,out,gotok)
Aplcb trace;			/* Trace control vector.					*/
int stmtno;			/* Next statement to be executed.			*/
Aplfunc fp;			/* Function definition.					*/
Aplcb out;			/* Output from current statement.			*/
Apltoken gotok;		/* Not NULL if this is a branch statement.	*/
{
	Funcgoto; Funcmsg; Funcsusp; Functrac; Functrgo; Quadout;
	extern Treelist treehdr;
	extern int aplerr;
	int brstmt;

	if (aplerr == 0 && gotok != NULL) {
		brstmt = stmtno;
		stmtno = funcgoto(fp,out,stmtno); /* branch */
		out = NULL; /* funcgoto will have freed */
		if (trace != NULL)
			functrgo(fp,trace,stmtno,brstmt); /* trace goto */
	}
	if (aplerr)
		switch (aplerr) {
			case 997: /* clear state indicator stack */
				if (treehdr->treeflag & SUSPNDED) {
					aplerr = 0; /* at prior suspended function */
					stmtno = funcsusp(); /* interact with terminal */
				}
				else
					stmtno = fp->funcstmt; /* get out */
				break;
			case 998: /* EOF - get out */
				stmtno = fp->funcstmt;
				break;
			default: /* all other errors */
				funcmsg(fp,treehdr->avloff,stmtno); /* Print msg */
				stmtno = funcsusp(); /* interact with terminal */
				break;
		} /* end switch */
	else if (gotok == NULL) {
		if (out != NULL && treehdr->lastfun != LEFT_ARROW)
			out = quadout(out); /* print result */
		if (trace != NULL)
			functrac(fp,trace,stmtno,out); /* trace, maybe */
	}
	endoper(out);
	return(stmtno);
}
