/* Copyright (C) 1994 by Thomas Glen Smith.  All Rights Reserved. */
/* funcexec APL2 V1.0.0 ************************************************
* Called by funcmain after variables have been localized, funcexec     *
* handles the execution of statements in the function.                 *
***********************************************************************/
#define INCLUDES APLCB+APLCHDEF+APLDEBUG+APLFUNCI+APLTOKEN+STDIO+TREE
#include "includes.h"
void funcexec(stmtstrt)
int stmtstrt;            /* statement to start or resume with */
{
	Codechar; Endoper; Funcexee; Funcstop; Funcsusp; Functrst;
     extern int aplerr;
     extern Treelist treehdr;
     Aplcb stop,trace;
     int stmtno;
     Aplfunc fp;
     char *nameptr;
	#if APL_DEBUG
	void mem_check(void);
	mem_check();
	#endif

     fp = treehdr->avlfun; /* function definition */
     nameptr = fp->funcname->token_ptr.token_string;
     stop = functrst(codechar(APL_S),nameptr); /* get stop vector */
     trace = functrst(codechar(APL_T),nameptr); /* get trace vector */
     for (stmtno = stmtstrt;
          aplerr == 0 && stmtno < fp->funcstmt;
		stmtno++, fp = treehdr->avlfun) {
          treehdr->avlstmt = stmtno; /* current statement */
          if (stop != NULL && funcstop(stop,stmtno)) {
               stmtno = funcsusp();
               if (stmtno <= 0 || stmtno > fp->funcstmt)
                    break; /* branch out of function */
          }
          stmtno = funcexee(trace,stmtno);
		#if APL_DEBUG
		mem_check();
		#endif
     }
     endoper(stop);
     endoper(trace);
}
