/* Copyright (C) 1995 by Thomas Glen Smith.  All Rights Reserved. */
/* formatt APL2 V1.0.0 *************************************************
* Called by formatr to use sprintf to round a value to the desired     *
* number of places, then format it using sprint, and then to remove    *
* any left and right zero fill done by sprintf.  Returns the address   *
* of the first significant digit left of the decimal point.            *
* If there are no significant digits, returns the address of the       *
* decimal point, if there is one, or the address of the end of string  *
* ('\0') otherwise.                                                    *
***********************************************************************/
#define INCLUDES STDIO+STRING
#include "includes.h"
char *formatt(buffer,value,places)
char		*buffer;	/* Place to store formatted output. */
double	value;	/* Value to be formatted. */
int		places;	/* Number of places desired right of decimal point. */
{
	char *bd,*be,*bp,*bq,ch;
	double dw;
	int i;

	if (i = places) /* decimals to print right of d.p. */
		for(dw = 10.0; i > 1; i--)
			dw *= 10.0; /* 10.0 for 1 decimal, 100.0 for 2,... */
	else dw = 1.0;
	value += 1.0 / (2.0 * dw); /* Round. */
	sprintf(buffer,"%f",value);
	bp = buffer; /* Start of buffer. */
	while(' ' == *bp) bp++; /* Find 1st non-blank. */
	while('0' == *bp) bp++; /* Find 1st significant digit. */
	be = buffer + strlen(buffer); /* End of buffer, addr('\0'). */
	for(bd = bp; bd < be; bd++)
		if (*bd == '.') break; /* Find decimal point. */
	bq = bd + places + 1; /* Maximum desired position. */
	while(be > bq) *(--be) = '\0'; /* Strip extra decimals. */
	for(bq = be - 1; bq > bd; bq--) {
		ch = *bq;
		if (ch == ' ' || ch == '0') /* Strip trailing blanks and zeros */
			*bq = '\0';            /* right of decimal point. */
		else break;
	}
	return(bp); /* Return ptr to 1st significant digit left of d.p. */
}
