/*Copyright (C) 1992, 1994 by Thomas Glen Smith.  All Rights Reserved.*/
/* formatm APL2 V1.0.0 *************************************************
* Called from formatd when left has been shaped to a vector having two *
* elements for each column of rite, rite having been reshaped, if      *
* necessary, to be a two-dimensional matrix.  Each pair of elements in *
* left describe the width and precision of a column of rite.  Formatm  *
* fills in any missing width/precision specifications.                 *
***********************************************************************/
#define INCLUDES APLCB+FORM
#include "includes.h"
void formatm(left,rite,cba)
Aplcb left,rite,cba;
{
	Endoper; Formate; Formatf; Getcb; Temp;
     extern int apldigs, aplerr, indxorg;
	int *bp,i,j,k,*lp,*pp,w,*wp,*zp;

	i = *(cba->apldim + 1); /* Number of columns of input. */
     for (;;) {
     	if (aplerr) break;
	     lp = left->aplptr.aplint;
          bp = Bixcb;
	     pp = Precb;
	     wp = Widcb;
          zp = Zixcb;
		j = indxorg;
          k = 0;
	     while(i--) {
          	*bp++ = j++; /* index vector = 1, 2, 3, ... */
	     	w = *wp++ = *lp++;
	     	if (apldigs < w) aplerr = 28;
	     	if ( 0 > w) aplerr = 29;
	          *pp++ = *lp++;
               *zp++ = (w == 0); /* which columns have widths of zero */
               k |= (w == 0); /* k == 1 if some widths are zero */
	     }
          endoper(temp(left));
		if (aplerr) break;
		if (k) { /* some widths are zero? */
			formate(rite,cba); /* Widths for e-notation. */
			formatf(rite,cba); /* Widths for f-notation. */
		}
          break; /* final break of for(;;) */
     }
}
