/*Copyright (C) 1992, 1996 by Thomas Glen Smith.	All Rights Reserved.*/
/* formatg APL2 V1.0.0 *************************************************
* Called from form after rite is made matrix, vectors widthcb,  precb  *
* filled with widths and precisions for formatting columns of rite.  If*
* precision < 0, e-notation indicated, e.g. 1.234e2 for 123.4, and abs.*
* value of indicator gives number of digits in the multiplier.  Pos.   *
* precision means f-notation, e.g. 123.4, and the indicator gives 	 *
* digits to right of decimal point.						 	 *
***********************************************************************/
#define INCLUDES APLCB+FORM+ERRNO
#include "includes.h"
Aplcb formatg(rite,cba,dimcb)
Aplcb rite,cba,dimcb;
{
	Errstop; Formath; Formaty; Formatz; Getcb; Intcopy;
	extern int aplerr, indxorg;
	Aplcb *bp,newdim,out;
	int col,cols,datacnt,i,lastdim,rank,row,rows,type,width;
	int *dip,*ip,*pp,*sp,*wp;
	char *cp,*fch;
	double *dp;

	fch = formaty(); /* Get Lfc vector. */
	type = rite->aplflags & (APLMASK | APLAPL);
	for (datacnt = 0, i = *(cba->apldim + 1) - 1; i >= 0; i--)
		datacnt += *(Widcb + i);
	lastdim = datacnt;
	for (i = dimcb->aplcount - 2; i >= 0; i--)
		datacnt *= *(dimcb->aplptr.aplint + i);
	rank = dimcb->aplcount ? dimcb->aplcount : 1;
	out = getcb(NULL, datacnt, APLCHAR + APLTEMP, rank, NULL);
	for (;;) { if (aplerr) break;
		if (dimcb->aplcount)
			ip = intcopy(out->apldim, dimcb->aplptr.aplint,
				out->aplrank - 1, 1);
		*(out->apldim + rank - 1) = lastdim;
		dp=rite->aplptr.apldata; /* 1st input value. */
		bp=rite->aplptr.aplapl; /* 1st input value if mixed input. */
		cp=out->aplptr.aplchar; /* 1st output location */
		rows=*(rite->apldim); /* number of rows in rite */
		cols=*(rite->apldim+1); /* number of columns in rite */
		for (row=0; row<rows; row++) {
			wp = Widcb;   /* First column width. */
			dip = Digicb; /* First column max digits. */
			pp = Precb;   /* First column precision. */
			sp = Chrcol;  /* First column-is-all-char switch. */
			for (col=0; col<cols; col++) {
				if (type == APLNUMB)
					formath(*dp++,cp,(width=*wp++),*pp++,*dip++,fch);
				else formatz(*bp++,cp,(width=*wp++),*pp++,*dip++,fch,
					*sp);
				sp++; /* Bump pointer. */
				cp+=width; /* bump to next output location */
			}
		}
		break; /* final break of for(;;) loop */
	}
	return(errstop(0,NULL,rite,out));
}
