/*Copyright (C) 1992, 1995 by Thomas Glen Smith.  All Rights Reserved.*/
/* execqnls APL2 V1.0.0 ************************************************
* Called from execqnl.  System function quad_nl, name list subroutine. *
***********************************************************************/
#define INCLUDES APLCB+APLMEM+STRING+TREE
#include "includes.h"
#include "execqnli.h"
void execqnls(node,p)
Avlnode node; /* points to node of binary tree */
Nlparm p; /* structure for passing during recursion */
{
#include "quadext.h"
	Execqnlt; Imax; Lifo; Quadname;
	Aplcb wrk;
	Nlq op;
	int i,j;
	char *qn,*rn;

	if (node == NULL) return;
	execqnls(node->rite_child,p); /* do right branch, if any */
	for (;;) { /* Allows use of break. */
		wrk = node->avlleaf; /* do this leaf, if any */
		if (wrk == NULL)
			break; /* no leaf */
		if (0 == strcmp(node->avlname,quadfc)) break; /* Skip Lfc. */
		qn = quadname(node->avlname); /* Transform Q-names. */
		if (!execqnlt(qn,p->delim))
			break; /* bad name */
		if (!(	p->lab != 0 && wrk->aplflags & APLLABEL
			||	p->fun != 0 && wrk->aplflags & APLFUNC
			||	p->var != 0 && 
				!(wrk->aplflags & (APLLABEL | APLFUNC))))
			break; /* no match of type */
		j = strlen(qn); /* Length of new name. */
		p->outrows += 1; /* add name count */
		p->outcols = imax(p->outcols,j);
		i = sizeof(struct nlq) + ((qn == node->avlname) ? 0 : (j+1));
		op = lifo(&(p->nlphdr),malloc(i));
		if (op == NULL)
			return; /* out of memory */
		if (qn == node->avlname)
			op->nlstr = node->avlname; /* point to name */
		else { /* must copy Q-name buffer. */
			op->nlstr = rn = sizeof(Nlq) + (char*)op;
			strcpy(rn,qn); /* Copy transformed Q-name. */
		}
		break;
	}
	execqnls(node->left_child,p); /* do left branch, if any */
}
