/*Copyright (C) 1992, 1996 by Thomas Glen Smith.  All Rights Reserved.*/
/* execqfxh APL2 V1.0.0 ************************************************
* Called from execqfxd when the form of the function header has been   *
* determined, niladic, monadic, or dyadic, with or without result.     *
* Execqfxh will process the list of local variables.                   *
***********************************************************************/
#define INCLUDES APLCHDEF+APLCB+APLFUNCI+APLTOKEN
#include "includes.h"
void execqfxh(fp,tokhdr,curtok,tokcnt,curvar)
Aplfunc fp;		/* Function definition structure */
Apltoken tokhdr;	/* Points to array of function header tokens */
Apltoken curtok;	/* Points to token left of semicolon */
int tokcnt;		/* Count of tokens right of current one */
Apltoken curvar;	/* Current token on queue of local variables */
{
	Execqfxe; Fifo;
	extern int aplerr;

	if (0 == tokcnt--) return; /* backup to semicolon */
	while(tokcnt--) {
		curtok = execqfxe(tokhdr + tokcnt,0,93);
		if (aplerr) break; /* didn't get token type expected */
		curvar = fifo(&(fp->funcvars),curvar,curtok); /* locals */
		if (tokcnt == 0) return; /* all done */
		curtok = execqfxe(tokhdr + --tokcnt,SEMICOLON,93);
		if (aplerr) break; /* didn't find semicolon when expected */
	}
	if (aplerr == 0)
		aplerr = 93; /* bad syntax in function header */
}
