/*Copyright (C) 1992, 1995 by Thomas Glen Smith.  All Rights Reserved.*/
/* execqfxf APL2 V1.0.0 ************************************************
* Called from execqfxl to process any labels in the function.          *
***********************************************************************/
#define INCLUDES APLCB+APLCHDEF+APLFUNCI+APLTOKEN
#include "includes.h"
void execqfxf(fp)
struct aplfunc *fp; /* function definition structure */
{
	Fifo;
	extern int aplerr;
	Apltoken curtok,curvar=NULL,tokhdr;
	int stmtno,tokcnt;

	for (stmtno = 1 ; stmtno < fp->funcstmt ; stmtno++) {
		tokcnt = *(fp->functokc + stmtno); /* count of tokens */
		tokhdr = *(fp->functokp + stmtno); /* head of token list */
		curtok = tokhdr + --tokcnt; /* leftmost token in stmt */
		if (curtok->token_code != OPERAND_TOKEN) continue;
		if (tokcnt == 0) continue;
		if ((tokhdr + --tokcnt)->token_code != COLON) continue;
		curtok->token_offset = stmtno; /* save stmt number */
		curvar = fifo(&(fp->funclabs),curvar,curtok); /* queue */
		*(fp->functokc + stmtno) -= 2; /* reduce token count */
	}
}
