/*Copyright (C) 1992, 1996 by Thomas Glen Smith.  All Rights Reserved.*/
/* execqfxe APL2 V1.0.0 ************************************************
* Called from execqfxd, aplediu and aplediy to obtain the next function*
* header token. A code indicating the type of token expected is passed *
* as an argument. If code==0, either an OPERAND_TOKEN, or QUAD_IO or   *
* QUAD_CT are expected.  Otherwise, code contains the specific         *
* token_code expected.                                                 *
***********************************************************************/
#define INCLUDES APLTOKEN
#include "includes.h"
Apltoken execqfxe(curtok,code,errcode)
Apltoken curtok; /* current header token */
int code; /* expected token type */
int errcode; /* error code to set if necessary */
{
	Fifo;
	extern int aplerr;
	Apltoken ret;
	int curtype;

	ret = curtok;
	if (code == 0)
		switch (ret->token_code) {
			case OPERAND_TOKEN:
			case QUAD_CT:
			case QUAD_IO:
				return(ret); /* token is ok */
		}
	else if (code == ret->token_code) return(ret); /* token is ok */
	aplerr = errcode; /* bad syntax */
	return(NULL);
}
