/*Copyright (C) 1992, 1995 by Thomas Glen Smith.  All Rights Reserved.*/
/* execqfxa APL2 V1.0.0 ************************************************
* Called from execqfx and apledit to allocate and initialize the       *
* aplfunc structure for the function being fixed.  Disposes of rite,   *
* i.e. will free if necessary.                                         *
***********************************************************************/
#define INCLUDES APLCB+APLFUNCI+APLMEM+APLTOKEN
#include "includes.h"
Aplfunc execqfxa(rite)
Aplcb rite;
{
	Aplcopy; Endoper;
	extern int aplerr;
	Aplfunc fp;

	if (NULL == (fp = malloc(sizeof(struct aplfunc)))) 
		return(NULL); /* out of memory */
	fp->funcsiqp = NULL;
	fp->funcflag = APLFUNC;
	fp->functype = 0;
	fp->functotl = 0;
	fp->funcstmt = 0;
	fp->functokc = NULL;
	fp->functext = NULL;
	fp->funcname = NULL;
	fp->functokp = NULL;
	fp->functary = NULL;
	fp->funcvars = NULL;
	fp->funclabs = NULL;
	if (rite == NULL) fp->functext = NULL;
	else if (rite->aplflags & APLTEMP) {
		rite->aplflags -= APLTEMP; /* mark as permanent */
		fp->functext = rite;
	}
	else {
		fp->functext = aplcopy(rite); /* copy permanent aplcb */
		if (aplerr) {
			endoper(rite);
			free(fp); /* free memory for aplfunc */
			fp = NULL; /* return a null pointer */
		}
	}
	return(fp);
}
