/* Copyright (C) 1994 by Thomas Glen Smith.  All Rights Reserved. */
/* execqcr APL2 V1.0.0 *************************************************
* Called by execmonq.                                                  *
* System function quad_cr, canonical representation.                   *
***********************************************************************/
#define INCLUDES APLCB+APLFUNCI+TREE
#include "includes.h"
Aplcb execqcr(rite)
Aplcb rite;
{
	Aplcopy; Chrcopy; Errinit; Errstop; Getcb; Nestchar; Temp; Treenode;
	extern int aplerr;
	Avlnode p;
     Aplcb cb,*cbp,out=NULL;
	int cbcount,datatype,maxlen,thislen;
	static char blank=' ';
	char *op;

	for (;;) { /* Lets me use break. */
		if (errinit()) break; /* Error. */
		if (APLCHAR != rite->aplflags & APLMASK || 1 < rite->aplrank ||
			0 == rite->aplcount) {
				aplerr = 109; /* Bad operand. */
				break;
		}
		if (NULL != (p = treenode(rite->aplptr.aplchar)) &&
			((Aplcb) p->avlleaf)->aplflags & APLFUNC) {
			cb = ((Aplfunc) p->avlleaf)->functext;
			datatype = cb->aplflags & (APLMASK | APLAPL);
			if (datatype == APLCHAR)
				out = temp(aplcopy(cb));
			else out = nestchar(cb);
		} else {
			out = getcb(NULL,0,APLCHAR+APLTEMP,2,NULL); /* 0-by-0 */
			if (out != NULL)
				*(out->apldim) = *(out->apldim+1) = 0;
		}
		break; /* Final break from for(;;). */
	} /* End for(;;) */
	return(errstop(0,NULL,rite,out));
}
