/* Copyright (C) 1993 by Thomas Glen Smith.  All Rights Reserved. */
/* execmoni - APL2 V1.0.0 **********************************************
* Called from execmons to check for and obtain the entry point to a    *
* monadic function.                                                    *
***********************************************************************/
#define INCLUDES APLCB+APLDERIV+FUNCODES+FUNSTRUC
#include "includes.h"
int execmoni(fun,arg,pep)
void *fun; /* function description */
void **arg; /* possible function argument */
sub_dyad *pep; /* derived function entry point */
{
     Monfront;
     extern int aplerr;
     int code,ret;
     Scalar_monadics *smp=NULL;

     if (aplerr) return(NO_TYPE);
     code = ((Codes *)fun)->funky_flags;
     switch(code) {
          case SCMD: /* monadic scalars */
               *arg = &(((Scalars *)fun)->mona);
          case MSMD: /* monadic scalars not, roll */
               if (*arg == NULL) *arg = &(((Msmd *)fun)->mona);
               pep->moa = monfront;
               ret = MOA; /* monadic w/special argument */
               break;
          case MXMO: /* compute */
          case MIXD: /* shape, interval,... */
		case UPAR: /* first */
               pep->mon = ((Mixa *)fun)->mona.epmix;
               ret = MON;
               break;
          case MIXC: /* ravel */
               pep->mex = ((Mixa *)fun)->mona.epmixe;
               ret = MEX;
               break;
          case SAME: /* transpose, gradedn, gradeup */
			pep->dix = ((Dmxo *)fun)->dyad.epdix;
			ret = DIX; /* Aplcb ep(NULL, Aplcb) */
               break;
          case MIXF: /* circle-bar, reverse, default = first axis */
          case MIXL: /* circle-stile, reverse, default = last axis */
          case MIXA: /* ravel, enclose, disclose */
               pep->mox = ((Mixa *)fun)->mona.epmixa;
               ret = MOX;
               break;
          case MIXE: /* enclose */
          case MIXG: /* disclose */
          	pep->mex = ((Mixa *)fun)->mona.epmixe;
               ret = MEX;
               break;
          default:
          	ret = NO_TYPE;
               break;
     } /* end switch */
     return(ret);
}
