/* Copyright (C) 1993 by Thomas Glen Smith.  All Rights Reserved. */
/* execexej APL2 V1.0.0 ************************************************
* Called by execexeg to evaluate a parenthesized expression.           *
***********************************************************************/
#define INCLUDES TREE+APLTOKEN
#include "includes.h"
Apltoken execexej(void)
{
     Execexed; Execinit; Execpop; Execterm; Pop;
     extern Treelist treehdr;
     extern int aplerr;
     Apltoken op=NULL;
	struct treelist *bug;

	bug = treehdr;
     execinit(); /* push a new execstk element on stack */
     if (aplerr) return(NULL);
     execexed(); /* mainline */
     if (aplerr) return(NULL);
     op = pop(&(treehdr->avlexec->avloprst));
     if (op == NULL)
          op = pop(&(treehdr->avlexec->avlfunst));
     if (treehdr->avlexec->avloprst != NULL ||
          treehdr->avlexec->avlfunst != NULL)
          aplerr = 61; /* stack should be empty */
     else if (op == NULL)
          aplerr = 60; /* missing result */
     execterm(); /* pop the top execstk element from stack */
     return(op); /* return token for operand */
}

