/* Copyright (C) 1996 by Thomas Glen Smith.	All Rights Reserved. */
/* execexee APL2 V1.0.0 ************************************************
* Called by execnext to see if operand c/b derived from current token. *
* If so, *ptop set to op. tok. ptr, *pfun set to NULL.	Else pfun points*
* to func/operator.  Returns 0 if niladic w/o return is executed, or if*
* any other condition that should cause execexed to quit processing.   *
***********************************************************************/
#define INCLUDES STDIO+APLCHDEF+APLTOKEN+APLCB+TREE+FUNCODES+FUNSTRUC
#include "includes.h"
int execexee(pfun,ptop)
Apltoken pfun[]; /* current input token */
Apltoken ptop[]; /* argument pointer */
{
	Execexef; Execexeg; Execexei; Execfree; Execoptk; Lifo; Pop;
	extern Treelist treehdr;
	extern int aplerr;
	Apltoken op,tok,wrk;
	Codes *cp;
	Oper *fun;
	int noexit=1,ret=1;

	*ptop = *pfun = NULL; /* initialize */
	if ( aplerr || (NULL == (wrk = treehdr->avltokhd))
		|| (wrk->token_code == LEFT_BRACKET)
		|| (wrk->token_code == SEMICOLON) ) return(0);
	*pfun = tok = execexeg(); /* Get input, handle brackets, identify */
	if (aplerr) return(0);	 /* functions, operators. */
	tok->token_work = NULL; /* initialize work pointers */
	if (tok->token_code == FUNCTION_TOKEN) {
		cp = (Codes *) fun = tok->token_ptr.token_function;
		if ((cp->funky_flags & OPER) && (cp->funky_code != APL_NULL))
			noexit = fun->eptok(tok); /* operator transform */
		ret = noexit & (aplerr == 0);
	}
	else if (tok->token_code == LEFT_PAREN) {
		execfree(tok);
		*pfun = tok = NULL;
		ret = 0;
	}
	else {
		op = execexef(tok); /* try quad input */
		if (op != NULL) *pfun = tok = op; /* substitute terminal input */
		if (tok->token_code == OPERAND_TOKEN)
			ret = execexei(pfun,ptop,tok); /* defined function check */
		else {
			*ptop = execoptk(pfun); /* test for operand */
			ret = (aplerr == 0); /* ok to continue processing */
		}
	}
	if (aplerr == 0 && NULL != (wrk = treehdr->avltokhd)
		&& wrk->token_code == DOT) {
		if (tok == NULL) /* tok s/b an operator or function. */
			aplerr = 63; /* Missing operator or function. */
		else {
			tok = lifo(&(treehdr->avlexec->avlfunst),tok); /* stack */
			*pfun = tok = execexeg(); /* Get input (DOT) */
			cp = (Codes *) fun = tok->token_ptr.token_function;
			noexit = fun->eptok(tok); /* operator transform */
		}
		ret = noexit & (aplerr == 0);
	}
	return(ret);
}
