/* Copyright (C) 1993 by Thomas Glen Smith.	All Rights Reserved. */
/* execdyaj APL2 V1.0.0 ************************************************
* Called from execdyan to perform a builtin APL dyadic function.		 *
***********************************************************************/
#define INCLUDES APLTOKEN+APLCB+FUNSTRUC+FUNCODES+TREE
#include "includes.h"
Aplcb execdyaj(fun,left,rite)
void *fun; /* function structure - see funstruc.h */
Aplcb left,rite; /* function arguments */
{
	Drop2; Errstop; Execaxis; Execaxiv; Execdyak; Laminate; Mod;
	Partitn; Scalax;
	extern int aplerr;
	extern Treelist treehdr;
	double dblaxis;
	int axis,code;
	Aplcb axcb;

	code = ((Codes *)fun)->funky_flags;
	if (axistest(treehdr->avlexec->avlfunst))
		axcb = execaxis(&(treehdr->avlexec->avlfunst));
	else axcb = NULL;
	if ((code & AXED)) /* Is it drop2, partition, squad, or take2? */
		switch(code) {
			case DIXE:
				return(((Dmxo *)fun)->dyad.epdixe(left,rite,axcb));
			case DIXS:
				return(((Dmxo *)fun)->dyad.epdixf(left,rite,axcb,NULL));
			case MIXE:
			case UPAR: /* Take2. */
				return(((Mixa *)fun)->dyad.epdixe(left,rite,axcb));
			default:
				return(((Dmxo *)fun)->dyad.epdixe(left,rite,axcb));
		}
	axis = -1; /* default = take the default axis */
	if (code & AXIS) {
		if (axcb != NULL) {
			dblaxis = execaxiv(axcb);
			if (aplerr)
				return(errstop(0,left,rite,NULL));
			if (mod(dblaxis,1.0) != 0.0)
				if (code == MIXC)
					return(laminate(left,rite,dblaxis));
				else return(errstop(9,left,rite,NULL)); /* bad axis */
			axis = dblaxis; /* convert axis to integer */
		}
	}
	else if (axcb != NULL)
		if (code & SCALAR && code & DYADIC)
			return(scalax(fun,left,rite,axcb));
		else return(errstop(89,left,rite,axcb)); /* axis out of place */
	return(execdyak(fun,left,rite,axis));
}
