/*Copyright (C) 1992, 1995 by Thomas Glen Smith.  All Rights Reserved.*/
/* encode APL2 V1.0.0 **************************************************
* Given the correct arguments, encode gives the inverse of decode.     *
* More generally, encode is based on the residue function.             *
***********************************************************************/
#define INCLUDES APLCB
#include "includes.h"
Aplcb encode(left,rite)
Aplcb left,rite;
{
	Encodeb; Encodec; Errstop; Getcb; Intcopy; Matchok;
	int datacnt,datatyp,i,*ip,rank;
	Aplcb out;

	if (!matchok(&left,&rite,APLINT + APLNUMB))
		return(NULL);
	datacnt = left->aplcount * rite->aplcount;
	datatyp = left->aplflags & APLMASK;
	rank = left->aplrank + rite->aplrank;
	out = getcb(NULL,datacnt,datatyp+APLTEMP,rank,NULL);
	if (rank > 1) { /* set dimensions */
		ip=intcopy(out->apldim,left->apldim,left->aplrank,1);
		ip=intcopy(ip,rite->apldim,rite->aplrank,1);
	}
	if (datacnt) switch (datatyp) {
		case APLNUMB:
			encodeb(left,rite,out,
				left->aplptr.apldata,
				rite->aplptr.apldata,
				out->aplptr.apldata
			);
			break;
		case APLINT:
			encodec(left,rite,out,
				left->aplptr.aplint,
				rite->aplptr.aplint,
				out->aplptr.aplint
			);
	} /* end switch */
	return(errstop(0,left,rite,out));
}
