/* Copyright (C) 1993 by Thomas Glen Smith.  All Rights Reserved. */
/* eachdyag APL2 V1.0.0 ************************************************
* Called from eachdyae, eachdyaf and execjot2 to process the next pair *
* of args.                                                             *
***********************************************************************/
#define INCLUDES APLDERIV+APLCB
#include "includes.h"
Aplcb eachdyag(dp,deriv_sub_ptr,left,rite)
Aplderiv dp; /* function describing derived function */
Deriv_sub *deriv_sub_ptr; /* identifies function to be processed */
Aplcb left,rite; /* arguments */
{
     Aplcb out;

     switch (deriv_sub_ptr->type) {
		case DOX:
			out = deriv_sub_ptr->func.dox
				(left,rite,dp->deriv_axis_cb);
			break;
          case DIX: /* mixed dyadic w/o axis */
               out = deriv_sub_ptr->func.dix
                    (left,rite);
               break;
          case DNL: /* mixed dyadic w/o axis */
               out = deriv_sub_ptr->func.dnl
                    (left,rite,NULL,NULL);
               break;
          case WAX: /* mixed dyadic with axis */
               out = deriv_sub_ptr->func.wax
                    (left,rite,dp->deriv_axis_int);
               break;
          case DBX: /* mixed dyadics with real axis (laminate) */
               out = deriv_sub_ptr->func.dbx
                    (left,rite,dp->deriv_axis_dbl);
               break;
          case DRV: /* derived function */
               out = deriv_sub_ptr->func.drv
                    (deriv_sub_ptr->fun,left,rite);
               break;
     } /* end switch */
     return(out);
}
