/* Copyright (C) 1993 by Thomas Glen Smith.  All Rights Reserved. */
/* eachdyaf APL2 V1.0.0 ************************************************
* Called from eachdyad when neither argument is empty.                 *
***********************************************************************/
#define INCLUDES APLDERIV+APLCB
#include "includes.h"
Aplcb eachdyaf(dp,left,rite)
Aplderiv dp; /* function describing derived function */
Aplcb left,rite; /* arguments */
{
     Aplcopy; Conform; Eachalc; Eachdyag; Eachdyah; Eachwrk; Endoper;
	Errstop; Getcb; Intcopy; Perm; Temp;
     extern int aplerr;
     Aplcb big, *cp, lit, out, wrk, wrkleft=NULL, wrkrite=NULL;
     int *dimptr,i;

     if (!conform(left,rite,0,&big,&lit))
          return(errstop(17,left,rite,NULL)); /* not conformable */
     if (NULL != (out = eachalc(big))) {
     	wrkleft = eachwrk(left);
          wrkrite = eachwrk(rite);
          if (aplerr == 0)
		     for (i=0, cp = out->aplptr.aplapl;
               	i < out->aplcount; i++) {
	               wrk = eachdyag(dp,&(dp->deriv_left),
    	     	     	eachdyah(i,left,wrkleft),
         	     		eachdyah(i,rite,wrkrite));
				if (wrk == NULL) *cp++ = NULL;
				else if (wrk->aplflags & APLTEMP) *cp++ = perm(wrk);
				else *cp++ = aplcopy(wrk);
			}
     }
     if (wrkleft) endoper(temp(wrkleft));
     if (wrkrite) endoper(temp(wrkrite));
     return(errstop(0,left,rite,out));
}
