/* Copyright (C) 1993 by Thomas Glen Smith.  All Rights Reserved. */
/* dyadicm APL2 V1.0.0 *************************************************
* Called by cdyadic, dyadic, execdyat, idyadic, relative, and relativf.*
***********************************************************************/
#define INCLUDES APLCB
#include "includes.h"
Aplcb dyadicm(left,rite,dataout,leftptr,riteptr,leftinc,riteinc,dtype)
Aplcb left, rite; /* operands */
double *dataout[], *leftptr[], *riteptr[];
int dtype, *leftinc, *riteinc;
{
     Aplcopy; Conform; Errstop; Getcb; Intcopy;
     Aplcb big,lit,out=NULL;
     int *dimbig,*dimleft,*dimptr,*dimrite,i,ok;

     if (!conform(left,rite,0,&big,&lit))
          return(errstop(17,left,rite,out)); /* not conformable */
     if (big->aplcount == 0 && dtype == APLAPL) { /* capture prototype */
     	out = aplcopy(big);
          if (out == NULL) return(errstop(0,left,rite,out));
          out->aplflags |= APLTEMP;
     } else {
	     out=getcb(NULL,big->aplcount,dtype+APLTEMP,big->aplrank,NULL);
          if (out == NULL) return(errstop(0,left,rite,out));
	     if (out->aplrank > 1)
	          dimptr=intcopy(out->apldim,big->apldim,out->aplrank,1);
     }
     *dataout=out->aplptr.apldata;
     *leftptr=left->aplptr.apldata;
     *riteptr=rite->aplptr.apldata;
     *leftinc=!(left->aplcount==1);
     *riteinc=!(rite->aplcount==1);
     return(out);
}
