/* Copyright (C) 1994 by Thomas Glen Smith.  All Rights Reserved. */
/* dyadcom APL2 V1.0.0 *************************************************
* called by dyadset and preduces to determine the desired input/output *
* data types, and the routine to do the scalar dyadic processing.      *
***********************************************************************/
#define INCLUDES APLCB+FUNCODES+FUNSTRUC
#include "includes.h"
SCALAR_PROC dyadcom(pfun, pintype, poutype, ltype, rtype)
void *pfun;   /* Describes the scalar dyadic. */
int *pintype,*poutype; /* Set by dyadcom to required data types. */
int ltype,rtype; /* Argument data types. */
{
	Dyadoper;
     extern int aplerr;
     SCALAR_PROC oper=NULL;
     Scalar_dyadics *fun;
     int code,flags;

	code = ((Codes *)pfun)->funky_code;
	switch (flags = ((Codes *)pfun)->funky_flags) {
          case EQNE:
	     	fun = &(((Eqne *)pfun)->rel.dyad);
               break;
          case SCMD: /* dyadic scalars */
               fun = &(((Scalars *)pfun)->dyad);
               break;
          case SCDO: /* and, less, greater, etc. */
               fun = &(((Rela *)pfun)->dyad);
               break;
          default:
               return(NULL); /* no match */
     }
     if (ltype == APLCHAR || rtype == APLCHAR) fun = pfun;
	return(dyadoper(fun, pintype, poutype, ltype, rtype, flags, code));
}
