/* Copyright (C) 1994 by Thomas Glen Smith.  All Rights Reserved. */
/* dividex APL2 V1.0.0 *************************************************
* Called by logrithx, powerx, and residuex.                            *
* Returns the quotient of dividing left by rite.                       *
***********************************************************************/
#define INCLUDES 0
#include "includes.h"
void dividex(left,rite,ret)
double *left,*rite,*ret;
{
	extern int aplerr;
     double al,ar,bl,br,den;

	al = *left;     /* real part */
     bl = *(left+1); /* imaginary part */
	ar = *rite;     /* real part */
     br = *(rite+1); /* imaginary part */
     if (ar == 0e0 && br == 0e0) {
     	aplerr = 39; /* attempt to divide by 0 */
          return;
     }
     den = ar * ar + br * br;
     *ret = (al * ar + bl * br) / den;
     *(ret+1) = (bl * ar - br * al) / den;
}
