/* Copyright (C) 1993 by Thomas Glen Smith.  All Rights Reserved. */
/* disclose APL2 V1.0.0 ************************************************
* Structures rite into an array, axes defining the axes of the result. *
***********************************************************************/
#define INCLUDES APLCB
#include "includes.h"
Aplcb disclose(rite, axes)
Aplcb rite;	/* Operand to be "disclosed." */
Aplcb axes;	/* NULL, or vector of axis values. */
{
     Aplcopy; Errinit; Errstop; Temp; Typeget;
     Aplcb disclosf(Aplcb, Aplcb, int, int);
     Aplcb *cb, out, wrk;
     extern int aplerr;
     int dtype=0, i, rank=0, tempsave;

     if (errinit()) return(errstop(0,axes,rite,NULL));
     if (!(rite->aplflags & APLAPL)) /* copy if not nested */
          return(errstop(0,NULL,axes,temp(aplcopy(rite))));
     if (tempsave = rite->aplflags & APLTEMP) /* save temp flag */
          rite->aplflags -= APLTEMP; /* and mark rite permanent */
     for(cb=rite->aplptr.aplapl, i=rite->aplcount; aplerr==0 && i; i--) {
          dtype=typeget(dtype,(wrk=*cb++)->aplflags & (APLMASK+APLAPL));
          if (wrk->aplrank) /* don't check scalars */
               if (rank == 0) rank = wrk->aplrank;
               else if (rank != wrk->aplrank) aplerr = 122;
     }
     if (aplerr == 0)
          out = disclosf(rite,axes,dtype,rank);
     rite->aplflags += tempsave; /* restore temporary flag */
     return(errstop(0,NULL,rite,out));
}
