/* Copyright (C) 1993 by Thomas Glen Smith.  All Rights Reserved. */
/* convert APL2 V1.0.0 *************************************************
* Called by preduces.                                                  *
* Converts the argument aplcb to the specified data type.              *
***********************************************************************/
#define INCLUDES APLCB
#include "includes.h"
Aplcb convert(rite,otype)
Aplcb rite; /* Argument to be converted */
int otype;  /* Desired output data type. */
{
     Complex; Errstop; Integer; Real;
     extern int aplerr;
     Aplcb out=NULL;
     int itype;

     itype = rite->aplflags & (APLMASK + APLAPL);
     if (itype == otype) return(rite);
     switch (otype) {
     	case APLNUMB: return(real(rite));
          case APLINT:  return(integer(rite));
          case APLCPLX: return(complex(rite));
          default:      return(errstop(999,NULL,rite,NULL));
     }
}
