/* Copyright (C) 1994 by Thomas Glen Smith.	All Rights Reserved. */
/* comprest APL2 V1.0.0 ************************************************
* Called by compress to finish processing when out->aplcount > 0.      *
***********************************************************************/
#define INCLUDES APLCB
#include "includes.h"
void comprest(left,rite,out,axis,axicnt,botcnt,topcnt,datatyp,fill)
Aplcb left,rite,out;
int axis,axicnt,botcnt,topcnt,datatyp,fill;
{	Aplfill; Dtacopy; Getcb; Temp;
	int axi,*dimptr,hit=0,incr,jw,mw,sincr,top;
	char *fillptr,*icp,*ocp,*tcp;
	Aplcb fillcb=NULL, *fillsave=NULL, fillwk=NULL;

	if (fill)
		if (datatyp == APLAPL)
			if (rite->aplrank > 1) {
				hit = 1;  /* use subarray fill */
				fillcb = getcb(NULL,botcnt,APLAPL,1,NULL);
				if (fillcb == NULL) return;
				fillsave = fillcb->aplptr.aplapl;
				((Aplcb*)fillptr) = &fillwk;
			} else {
				fillcb = aplfill(rite);
				if (fillcb == NULL) return;
				((Aplcb*)fillptr) = &fillcb;
			} else fillptr = aplfill(rite);
	incr = (1 == rite->aplcount) ? 0 : botcnt * rite->aplsize;
	sincr = (1 == axicnt * botcnt) ? 0 : incr;
	ocp = out->aplptr.aplchar; /* 1st output location */
	for (top = 0; top < topcnt; top++) {
		icp = rite->aplptr.aplchar + top * axicnt * incr;
		dimptr = left->aplptr.aplint; /* compression vector */
		if (hit) { /* use subarray fill */
			fillcb->aplptr.aplapl = (Aplcb*)icp;
			fillwk = aplfill(fillcb);
		}
		for (axi = jw = 0; jw < left->aplcount; jw++) {
			mw = *dimptr++;
			if (mw < 0) /* fill */
				ocp = dtacopy(ocp,fillptr,botcnt*-1*mw,0,datatyp);
			else { /* mw >= 0 means bump axi. */
				tcp = icp + axi * sincr;
				while (mw--)
					ocp = dtacopy(ocp,tcp,botcnt,1,datatyp);
				axi++;
			}
		}
		if (hit) {
			endoper(temp(fillwk));
			fillwk = NULL;
		}
	}
	if (fillcb != NULL) {
		if (fillsave != NULL)
			fillcb->aplptr.aplapl = fillsave;
		endoper(temp(fillcb));
	}
}
