/* Copyright (C) 1994 by Thomas Glen Smith.	All Rights Reserved. */
/* compress APL2 V1.0.0 ************************************************
* Called by slashtrb.                                                  *
* Output is same shape as rite, except a scalar rite produces a vector *
* out. Items of output chosen from rite according to the non-zero items*
* of left. If rite were vector 1 2 3 4 5, and left vector 1 0 1 0 1,   *
* result w/b 1 3 5.  For rite of rank > 1, axis arg determines which   *
* dimension of rite is compressed.		                               *
***********************************************************************/
#define INCLUDES APLCB
#include "includes.h"
Aplcb compress(left,rite,axis)
Aplcb left,rite;
int axis; /* Axis, relative to Index Origin in force. */
{
	Comexpa; Comexpb; Comprest; Errstop; Temp;
	int axicnt,axires,botcnt,datatyp,fill=0,iw,jw,topcnt;
	Aplcb out=NULL;

	if (NULL == (left = comexpa(left,rite,&axis,&axicnt,&botcnt,&topcnt)))
		return(errstop(0,left,rite,NULL));
	for(iw = axires = 0; iw < left->aplcount; iw++) { /* #items in axis */
		axires += (0 < (jw = *(left->aplptr.aplint + iw))) ? jw : -jw;
		if (jw < 0) fill = 1; /* there will be fill items */
	}
	if (left->aplcount != axicnt)
		if (rite->aplrank && !fill)
			return(errstop(31,temp(left),rite,NULL));
	if (NULL == (out = comexpb(rite,axis,axires,botcnt,topcnt,&datatyp)))
		return(errstop(0,temp(left),rite,out));
	/* now copy selected input to output */
	if (out->aplcount) /* not empty? */
		comprest(left,rite,out,axis,axicnt,botcnt,topcnt,datatyp,fill);
	return(errstop(0,temp(left),rite,out));
}
